<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'addresses';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'company',
        'address_line_1',
        'address_line_2',
        'address_line_3',
        'town',
        'county',
        'post_code',
        'phone_no',
        'phone_no_1',
        'phone_no_2',
        'country_id',
        'default_address',
        'customer_id',
        'user_id'
    ];
    
    public function country()
    {
        return $this->belongsTo('App\Country');
    }
    
    public function setCustomerIdAttribute($customerId)
    {
        $this->attributes['customer_id'] = ($customerId !== '') ? $customerId : null;
    }
    
    public function setAddressLine1Attribute($addressLine1)
    {
        $this->attributes['address_line_1'] = ($addressLine1 !== '') ? $addressLine1 : null;
    }
    
    public function setTownAttribute($town)
    {
        $this->attributes['town'] = ($town !== '') ? $town : null;
    }
    
    public function setCountyAttribute($county)
    {
        $this->attributes['county'] = ($county !== '') ? $county : null;
    }
    
    public function setPostCodeAttribute($postCode)
    {
        $this->attributes['post_code'] = ($postCode !== '') ? $postCode : null;
    }
}
