<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Banking extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'banking';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['date', 'bank_id', 'amount', 'payment_ref', 'transaction_id', 'user_id'];

    function setDateAttribute($date)
    {
        return $this->attributes['date'] = Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
    }
    
    function getDateAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d', $date)->format('d/m/Y');
    }
    
    public function bank()
    {
        return $this->belongsTo('App\Bank');
    }
    
    public function userProfile()
    {
        return $this->belongsTo('LaravelAcl\Authentication\Models\UserProfile', 'user_id');
    }
}
