<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CargoServiceRate extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'cargo_service_rates';
    
    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';
    
    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['collection_country_id', 'delivery_country_id', 'cargo_service_id', 'rate', 'cargo_type', 'status', 'user_id'];
    
    public function collectionCountry()
    {
        return $this->belongsTo('App\Country', 'collection_country_id', 'id');
    }
    
    public function deliveryCountry()
    {
        return $this->belongsTo('App\Country', 'delivery_country_id', 'id');
    }
    
    public function cargoService()
    {
        return $this->belongsTo('App\CargoService');
    }

}
