<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Customer extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'customers';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'email',          
        'title',          
        'first_name',     
        'last_name',
        'dob',
//        'address_line_1', 
//        'town',      
//        'county',   
//        'post_code',
//        'phone_no',
        'user_id'
    ];
    
    public function address()
    {
        return $this->hasOne('App\Address')->where('default_address', 1);
    }
    
    function setDobAttribute($date)
    {
        return $this->attributes['dob'] = ($date != '') ? Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d') : null;
    }
    
    function getDobAttribute($date)
    {
        if($date != '')
        {
            return Carbon::createFromFormat('Y-m-d', $date)->format('d/m/Y');
        }
    }
}