<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class CustomerInvoice extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'customer_invoices';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['sale_price', 'cost_price', 'customer_id', 'table_id', 'module_id', 'description', 'transaction_id', 'agent_transaction_id', 'status', 'user_id'];
    
    public function customer()
    {
        return $this->belongsTo('App\Customer');
    }
    public function module()
    {
        return $this->belongsTo('App\Module', 'module_id' );
    }
    
    function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('d/m/Y H:i:s');
    }
}
