<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerInvoiceData extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'customer_invoice_data';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['invoice_id', 'custom_field_id', 'field_value', 'user_id'];

    public function customField()
    {
        return $this->belongsTo('App\CustomField');
    }
}
