<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Amount;
use Illuminate\Http\Request;
use Session;

class AmountsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $where['user_id'] = userId();
        
        $amounts = Amount::where($where)->get();

        return view('amounts.index', compact('amounts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('amounts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|unique:amounts'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        Amount::create($requestData);

        Session::flash('flash_message', 'Amount added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $where['user_id'] = userId();
        
        $amount = Amount::where($where)->findOrFail($id);

        return view('amounts.edit', compact('amount'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|unique:amounts,amount,'.$id
        ]);
       
        $requestData = $request->all();
        
        $where['user_id'] = userId();
        $amount = Amount::where($where)->findOrFail($id);
        $amount->update($requestData);

        Session::flash('flash_message', 'Amount updated!');

        return response()->json(['response' => 'success']);
    }
}
