<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Api;
use Illuminate\Http\Request;
use Session;

class ApisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $apis = Api::get();

        return view('apis.index', compact('apis'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('apis.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'user_name' => 'required|alpha_dash_2|max:30|unique:apis',
            'api'       => 'required|alpha_dash_2|unique:apis',
            'url'       => 'required|url|unique:apis'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        Api::create($requestData);

        Session::flash('flash_message', 'API added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $api = Api::findOrFail($id);

        return view('apis.edit', compact('api'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'user_name' => 'required|alpha_dash_2|max:30|unique:apis,user_name,'.$id,
            'api'       => 'required|alpha_dash_2|unique:apis,api,'.$id,
            'url'       => 'required|url|unique:apis,url,'.$id
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $api = Api::findOrFail($id);
        $api->update($requestData);

        Session::flash('flash_message', 'API updated!');

        return response()->json(['response' => 'success']);
    }

    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = Api::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
}
