<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\BankAccount;
use Illuminate\Http\Request;
use Session;

class BankAccountsController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $bankAccounts = BankAccount::get();

        return view('bank_accounts.index', compact('bankAccounts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('bank_accounts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'account_name'   => 'required|alpha_dash_space|max:30|unique:bank_accounts',
            'account_number' => 'required|digits_between:10,18',
            'sort_code'      => 'required|digits_between:3,6',
            'bank_id'        => 'required'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        BankAccount::create($requestData);

        Session::flash('flash_message', 'Bank Account added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $bankAccount = BankAccount::findOrFail($id);

        return view('bank_accounts.edit', compact('bankAccount'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'account_name'   => 'required|alpha_dash_space|max:30|unique:bank_accounts,account_name,'.$id,
            'account_number' => 'required|digits_between:10,18',
            'sort_code'      => 'required|digits_between:3,6',
            'bank_id'        => 'required'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $bankAccount = BankAccount::findOrFail($id);
        $bankAccount->update($requestData);

        Session::flash('flash_message', 'Bank Account updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = BankAccount::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }   
}
