<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\CargoServiceRate;
use Illuminate\Http\Request;
use Session;

class CargoServiceRatesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index(Request $request)
    {
        $cargoType = $request['cargo_type'];
        $where['cargo_type'] = $cargoType;

        $cargoServiceRates = CargoServiceRate::where($where)->get();
        return view('cargo_service_rates.index', compact('cargoServiceRates', 'cargoType'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create(Request $request)
    {
        $cargoType = $request['cargo_type'];
        return view('cargo_service_rates.create', compact('cargoType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'collection_country_id' => 'required|unique:cargo_service_rates,collection_country_id,NULL,id,delivery_country_id,'.$request['delivery_country_id'].',cargo_service_id,'.$request['cargo_service_id'],
            'delivery_country_id'   => 'required',
            'cargo_service_id'      => 'required',
            'rate'                  => 'required|numeric'
        ]);
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        CargoServiceRate::create($requestData);

        Session::flash('flash_message', 'Module added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $cargoServiceRate = CargoServiceRate::findOrFail($id);

        return view('cargo_service_rates.edit', compact('cargoServiceRate'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'collection_country_id' => 'required|unique:cargo_service_rates,collection_country_id,'.$id.',id,delivery_country_id,'.$request['delivery_country_id'].',cargo_service_id,'.$request['cargo_service_id'],
            'delivery_country_id'   => 'required',
            'cargo_service_id'      => 'required',
            'rate'                  => 'required|numeric'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $cargoServiceRate = CargoServiceRate::findOrFail($id);
        $cargoServiceRate->update($requestData);

        Session::flash('flash_message', 'Cargo Service Rate updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = CargoServiceRate::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
}
