<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\CargoService;
use Illuminate\Http\Request;
use Session;

class CargoServicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index(Request $request)
    {
        $cargoType = $request['cargo_type'];
        $where['cargo_type'] = $cargoType;
        
        $cargoServices = CargoService::where($where)->get();

        return view('cargo_services.index', compact('cargoServices', 'cargoType'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create(Request $request)
    {
        $cargoType = $request['cargo_type'];
        
        return view('cargo_services.create', compact('cargoType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'  => 'required|alpha_dash_space|max:30|unique:cargo_services',
            'image' => 'image|mimes:jpeg,png,jpg,gif|max:200', //KB
        ]);
        
        $image = $request->file('image');
        
        if($image != '')
        {
            $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            $image->move('images/cargo_service_images/', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        CargoService::create($requestData);

        Session::flash('flash_message', 'Cargo Service added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $cargoService = CargoService::findOrFail($id);

        return view('cargo_services.edit', compact('cargoService'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
       $this->validate($request, [
            'name'  => 'required|alpha_dash_space|max:30|unique:cargo_services,name,'.$id,
            'image' => 'image|mimes:jpeg,png,jpg,gif|max:200', //KB
        ]);
       
        $image = $request->file('image');
        
        if($image != '')
        {
            if($request['image_name'] == '')
            {
                $fileName = md5(uniqid()).'.'.$image->getClientOriginalExtension();
            }else
            {
                $fileName = $request['image_name'];
            }
            
            $image->move('images/cargo_service_images/', $fileName);
            
            $request['image_name'] = $fileName;
        }
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $cargoService = CargoService::findOrFail($id);
        $cargoService->update($requestData);

        Session::flash('flash_message', 'Cargo Service updated!');

        return response()->json(['response' => 'success']);
    }

    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = CargoService::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
}
