<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\MnrService;
use Illuminate\Http\Request;
use Session;

class MnrServicesController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index(Request $request)
    {
        $type = $request['type']; 
        $where['type'] = $type;
        
        $mnrServices = MnrService::where($where)->get();

        return view('mnr_services.index', compact('type', 'mnrServices'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create(Request $request)
    {
        $type = $request['type'];
        
        return view('mnr_services.create', compact('type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'        => 'required|alpha_dash_space|max:255|unique:mnr_services',
            'category_id' => 'required',
            'amount'      => 'required|numeric',
            'url'         => 'required_if:type,2|url',
            'sort_order'  => 'digits_between:1,7'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        MnrService::create($requestData);
        
        Session::flash('flash_message', 'Service added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $mnrService = MnrService::findOrFail($id);

        return view('mnr_services.edit', compact('mnrService'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
       $this->validate($request, [
            'name'        => 'required|alpha_dash_space|max:255|unique:mnr_services,name,'.$id,
            'category_id' => 'required',
            'amount'      => 'required|numeric',
            'url'         => 'required_if:type,2|url',
            'sort_order'  => 'digits_between:1,7'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $mnrService = MnrService::findOrFail($id);
        $mnrService->update($requestData);
 
        Session::flash('flash_message', 'Service updated!');

        return response()->json(['response' => 'success']);
    }

    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = MnrService::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
}
