<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\NetworkCommission;
use App\NetworkCommissionScheme;
use App\NetworkIncentive;
use Illuminate\Http\Request;
use Session, Excel, Datatables;
use Carbon\Carbon;

class NetworkCommissionController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $networkCommission = NetworkCommission::get();

        return view('network_commission.index', compact('networkCommission'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('network_commission.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'        => 'required|alpha_dash_space|max:30|unique:network_commission',
            'topup_level' => 'required|digits_between:1,5'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        NetworkCommission::create($requestData);

        Session::flash('flash_message', 'Network Commission added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $networkCommission = NetworkCommission::findOrFail($id);

        return view('network_commission.edit', compact('networkCommission'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'name'        => 'required|alpha_dash_space|max:30|unique:network_commission,name,'.$id,
//            'topup_level' => 'required|digits_between:1,5'
        ]);
       
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $networkCommission = NetworkCommission::findOrFail($id);
        $networkCommission->update($requestData);

        Session::flash('flash_message', 'Network Commission updated!');

        return response()->json(['response' => 'success']);
    }

    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = NetworkCommission::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
    
    public function networkCommissionScheme(Request $request)
    {
        $where['id'] = $request['network_commission_id'];
        $networkCommission = NetworkCommission::where($where)->first();
        
        $where_1['network_commission_id'] = $request['network_commission_id'];
        
        $networkCommissionScheme = NetworkCommissionScheme::where($where_1)->orderBy('network_id', 'Asc')->orderBy('topup_level', 'Asc')->get();
        
        return view('network_commission.network_commission_scheme', compact('networkCommission', 'networkCommissionScheme'));
    }
    
    public function networkCommissionSchemeStore(Request $request)
    {
        $this->validate($request, [
            'network_id'            => 'required|unique:network_commission_scheme,network_id,NULL,id,network_commission_id,'.$request['network_commission_id'],
            'network_commission_id' => 'required',
            'commission.*'          => 'numeric',
            'sort_order'            => 'digits_between:1,7'
        ]);
        
        foreach ($request['commission'] as $key => $value):
          
            $data[] = array(
                'network_id'            => $request['network_id'],
                'network_commission_id' => $request['network_commission_id'],
                'topup_level'           => $key,
                'commission'            => $value,
                'sort_order'            => $request['sort_order'],
                'user_id'               => userId(),
                'created_at'            => date('Y-m-d H:i:s'),
                'updated_at'            => date('Y-m-d H:i:s')
            );
           
        endforeach;
        
        NetworkCommissionScheme::Insert($data);
        
        Session::flash('flash_message', 'Network Commission Scheme added!');

        return response()->json(['response' => 'success']);
    }
    
    public function networkCommissionSchemeUpdate(Request $request)
    {
        $this->validate($request, [
            'pk'    => 'required',
            'value' => 'required|numeric'
        ]);
        
        $where['id'] = $request['pk'];
        NetworkCommissionScheme::where($where)->update(array('commission' => $request['value']));

        return response()->json(['response' => 'success']);
    }    
    
    public function networkIncentiveList(Request $request)
    {
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
            $from = date('Y-m-d 00:00:00');
        }else
        {
            $from = getDateFrom($dateFrom);
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
            $to = date('Y-m-d 23:59:59');
        }else
        {
            $to = getDateTo($dateTo);
        }
        
        return view('network_commission.network_incentive_list', compact('dateFrom', 'dateTo', 'from', 'to'));
    }
    
    public function getNetworkIncentiveData(Request $request)
    { 
        $from = $request['from'];
        $to   = $request['to'];
        
        $networkIncentive = NetworkIncentive::with('SimInformationData')->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'DESC')->orderBy('sim_number', 'ASC')->orderBy('topup_level', 'DESC');
        
        return Datatables::eloquent($networkIncentive)
            ->editColumn('sim_information_data.agent_id', function ($networkIncentive) {
                return is_null($networkIncentive->simInformationData)?'Not Allotted':$networkIncentive->simInformationData->userProfile->first_name.' '.$networkIncentive->simInformationData->userProfile->last_name;
            })
            ->editColumn('product_date', function ($networkIncentive) {
                return getDateUk($networkIncentive->product_date);
            })
            ->addColumn('status', function($networkIncentive) {
                    $status = $networkIncentive->status;
                    if($status == 0)
                    {
                        return 'Incentive not Applied';
                    }else if($status == 1)
                    {
                        return 'Incentive Applied';
                    }else if($status == 2)
                    {
                        return 'Paid';
                    }
                return ;
            })
            ->make(true);
    }
    
    public function importNetworkIncentive(Request $request)
    {
        $this->validate($request, [
            'file' => 'required|mimes:csv,txt', //KB
        ]);
        
        $file = $request->file('file');
               
        $fileName = public_path().'/incentive_reports/'.date('Y-m-dH:i:s').'.'.$file->getClientOriginalExtension();
        $file->move('incentive_reports', $fileName);
        
        $myValueBinder = new StubValueBinder;

        $results = Excel::setValueBinder($myValueBinder)->load($fileName)->get();
        
//        Excel::filter('chunk')->setValueBinder($myValueBinder)->load($fileName)->chunk(250, function($results)
//        {
            foreach($results as $row)
            {
                $data[] = array(
                    'product'             => $row->product,
                    'product_date'        => getDateTime($row->date),
                    'sim_number'          => $row->simnumber,
                    'topup_level'         => $row->type,
                    'topup_face_value'    => $row->topup_facevalue, 
                    'product_incentive'   => str_replace('£', '', $row->incentive),
                    'suspected_deduction' => $row->suspected_deduction,
                    'boundle_incentives'  => $row->boundle_incentives,
                    'user_id'             => userId(),
                    'created_at'          => Carbon::now(),
                    'updated_at'          => Carbon::now()
                );
            }
//            Network Incentive Status 1 means Incentive Applied and Status 2 means Paid to customer
            NetworkIncentive::insertOnDuplicateKey($data);
            NetworkIncentive::updateNetworkIncentive();
//            unset($data);
//        });

        Session::flash('flash_message', 'Incentive Report Imported!');

        return response()->json(['response' => 'success']);
    }
    
    public function applyNetworkIncentive(Request $request)
    {
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        NetworkIncentive::updateNetworkIncentive($dateFrom, $dateTo);
        
        Session::flash('flash_message', 'Network Incentive Applied!');

        return response()->json(['response' => 'success']);
    }
    
    public function payNetworkIncentive(Request $request)
    {
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        $networkIncentive = NetworkIncentive::select(\DB::raw('agent_id, SUM(incentive) AS total'))
                                ->whereBetween('network_incentive.created_at', array($dateFrom, $dateTo))
                                ->where('status', 1)->whereNotNull('agent_id')
                                ->join('sim_information_data', 'network_incentive.sim_number' ,'sim_information_data.ssn')->groupBy('agent_id')
                                ->get();
        
        if($networkIncentive->count() > 0)
        {
            foreach($networkIncentive as $row):

                $data[] = array(
                    'amount'     => $row->total,
                    'action'     => 'Network Incentive Paid From '.$dateFrom.' To '.$dateTo,
                    'user_id'    => $row->agent_id,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now()
                );
            endforeach;

            \App\UserBalance::insert($data);
        }
        
        unset($data);
//      Status 2 means Paid to customer
        $data['status'] = 2;
        
        $result = NetworkIncentive::whereBetween('created_at', array($dateFrom, $dateTo))
                            ->where('status', 1)->update($data);
        
        if($result > 0)
        {
            Session::flash('flash_message', 'Network Incentive Paid!');
        return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Record Not Updated']);
        }
    }
}

use PHPExcel_Cell;
use PHPExcel_Cell_DataType;
use PHPExcel_Cell_IValueBinder;
use PHPExcel_Cell_DefaultValueBinder;


class StubValueBinder extends PHPExcel_Cell_DefaultValueBinder implements PHPExcel_Cell_IValueBinder
{
    public function bindValue(PHPExcel_Cell $cell, $value = null)
    {
        if (is_numeric($value))
        {

            $cell->setValueExplicit($value, PHPExcel_Cell_DataType::TYPE_STRING);

            return true;
        }

        // else return default behavior
        return parent::bindValue($cell, $value);
    }
}
