<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\PinNumber;
use Illuminate\Http\Request;
use Session;
use Datatables;

class PinNumbersController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */

    public function index(Request $request)
    {
        $pinNumber  = $request['pin_number'];
        $categoryId = $request['category_id'];
        $productId  = $request['product_id'];
        $amount     = $request['amount'];
        $status     = $request['status'];
        
        return view('pin_numbers.index', compact('pinNumber', 'categoryId', 'productId', 'amount', 'status'));
    }

    public function getData(Request $request)
    {
        $pinNumbers = PinNumber::with('product')->where(function ($query) use($request)
            {
                $categoryId = $request['category_id'];
                $pinNumber  = $request['pin_number'];
                $productId  = $request['product_id'];
                $amount     = $request['amount'];
                $status     = $request['status'];

                if($pinNumber != '')
                {
                    $query->where('pin_number', 'like', '%'.$pinNumber.'%');
                }

                if($productId != '')
                {
                    $query->where('product_id', $productId);
                }else if($categoryId != '')
                {
                    $query->whereExists(function ($query) use($categoryId) 
                    {
                        $query->select(\DB::raw(1))
                              ->from('products')
                              ->whereRaw('pin_numbers.product_id = products.id')->where('category_id', $categoryId);
                    });
                }

                if($amount != '')
                {
                    $query->where('amount', $amount);
                }

                if($status != '')
                {
                    if($status == 4)
                    {
                        $query->whereIn('status', [0, 1]);
                    }else
                    {
                        $query->where('status', $status);
                    }
                }
            });
            
        return Datatables::eloquent($pinNumbers)
            ->editColumn('product_id', function ($pinNumbers) {
                return $pinNumbers->product->name;
            })
            ->editColumn('status', function ($pinNumbers) {
                if($pinNumbers->status == 2)
                {
                    return '<button class="btn btn-info btn-sm" type="button">Used</button>';
                }else{
                    return setStatusHTML($pinNumbers->id, $pinNumbers->status);
                }
            })
            ->addColumn('action', function($pinNumbers) {
                return '<a href="'.url('/pin_numbers/'.$pinNumbers->id.'/edit').'" class="ajaxify"><i class="fa fa-edit"></i></a>';
            })->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('pin_numbers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'pin_number.*'    => 'required|digits_between:1,20|unique:pin_numbers,pin_number',
            'serial_number.*' => 'required|digits_between:1,20|unique:pin_numbers,serial_number',
            'sale_price'      => 'required|numeric',
            'category_id'     => 'required',
            'product_id'      => 'required',
            'amount'          => 'required',
            'expired_date'    => 'required'
        ]);
        
//        $request['user_id'] = userId();
//        $requestData = $request->all();
        
//        PinNumber::create($requestData);

        foreach ($request['pin_number'] as $key => $value):
          
            $data[] = array(
                'product_id'    => $request['product_id'],
                'pin_number'    => $value,
                'serial_number' => $request['serial_number'][$key],
                'amount'        => $request['amount'],
                'sale_price'    => $request['sale_price'],
                'expired_date'  => getDate2($request['expired_date']),
                'user_id'       => userId(),
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s')
            );
           
        endforeach;
        
        PinNumber::Insert($data);
        
        Session::flash('flash_message', 'Pin Number added!');

        return response()->json(['response' => 'success']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     *
     * @return \Illuminate\View\View
     */
    public function edit($id)
    {
        $pinNumber = PinNumber::findOrFail($id);

        return view('pin_numbers.edit', compact('pinNumber'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $this->validate($request, [
            'pin_number'    => 'required|digits_between:1,20|unique:pin_numbers,pin_number,'.$id,
            'serial_number' => 'required|digits_between:1,20|unique:pin_numbers,serial_number,'.$id,
            'product_id'    => 'required',
            'category_id'   => 'required',
            'product_id'    => 'required',
            'amount'        => 'required',
            'sale_price'    => 'required|numeric',
            'expired_date'  => 'required'
        ]);
        
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $pinNumber = PinNumber::findOrFail($id);
        $pinNumber->update($requestData);

        Session::flash('flash_message', 'Pin Number updated!');

        return response()->json(['response' => 'success']);
    }
    
    public function updateStatus(Request $request)
    {
        $id = $request['id'];
        $status = $request['status'];
        
        $data['status']  = $status;
        $data['user_id'] = userId();
        
        $result = PinNumber::where('id', $id)->update($data);

        if($result > 0)
        {
            if($status == 1)
            {
                $message = 'Status enabled!';
            }else
            {
                $message = 'Status disabled!';
            }
            
            Session::flash('flash_message', $message);
            return response()->json(['response' => 'success']);
        }else
        {
            $message = 'Status not updated!';
            
            return response()->json(['message' => $message]);
        }
    }
    public function pinNumbersSummary()
    {
        $pinNumbers = PinNumber::select(\DB::raw('product_id, amount, count(*) AS total, SUM(CASE WHEN status = 2 THEN 1 ELSE 0 END) AS used'))
                            ->groupBy('product_id','amount')->get();
        
        return view('pin_numbers.summary_report', compact('pinNumbers'));
    }
}
