<?php

namespace App\Http\Controllers;

use App\CustomerInvoice;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Topup;
use App\UnlockingMobile;
use App\User;
use Illuminate\Http\Request;
use Session, URL, Datatables;

class ReportsController extends Controller
{
    public function index()
    {
        $title = 'Reports';
        return view('reports.reports', compact('title'));
    }
    
    public function bankingList(Request $request)
    {
        $title    = 'e-Banking Report';
        $page     = $request['page'];
        $userId   = $request['user_id'];
        $userName = $request['user_name'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
        }
        
        return view('reports.banking_list', compact('title', 'page', 'userId', 'userName', 'dateFrom', 'dateTo'));
    }
    
    public function getBankingData(Request $request)
    { 
        $page     = $request['page'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];

        $userId = $this->userId($request['user_id'], $page);
        $from   = $this->dateFrom($dateFrom);
        $to     = $this->dateTo($dateTo);
        
        $banking = \App\Banking::with('bank')->where(function ($query) use($userId)
            {
                if($userId != '')
                {
                    $query->where('user_id', $userId);
                }
            })->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'desc');
            
        return Datatables::eloquent($banking, $page)
            ->editColumn('approved', function($banking) use($page) {
                if($banking->approved == 0):
                    if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
                    {
                        $status = '<a href="javascript:;" id="'.$banking->id.'" class="approved">
                            <button type="button" class="btn btn-warning btn-sm">Pending</button>
                        </a>';
                    }else
                    {
                        $status = '<button type="button" class="btn btn-warning btn-sm">Pending</button>';
                    }
                elseif($banking->approved == 1):
                    $status = '<button type="button" class="btn btn-success btn-sm">Approved</button>';
                elseif($banking->approved == 2):
                    $status = '<button type="button" class="btn btn-danger btn-sm">Rejected</button>';
                endif;
                
                return $status;
            })->make(true);
    }
    
    public function courierList(Request $request)
    {
        $cargoType = '';
        $page      = $request['page'];
        $type      = $request['type'];
        $userId    = $request['user_id'];
        $userName  = $request['user_name'];
        $dateFrom  = $request['date_from'];
        $dateTo    = $request['date_to'];
        $countryId = $request['country_id'];
        
        if($type == 1):
           $title = 'e-Courier Service';
        elseif($type == 2):
            $cargoType = $request['cargo_type'];
            if($cargoType == 1):
                $title = 'Air Cargo';
            elseif($cargoType == 2):
                $title = 'Sea Cargo';
            endif;
        endif;
           
        return view('reports.courier_list', compact('title', 'page', 'type', 'cargoType', 'userId', 'userName', 'dateFrom', 'dateTo', 'countryId'));
    }
    
    public function getCourierData(Request $request)
    { 
        $page      = $request['page'];
        $type      = $request['type'];
        $cargoType = $request['cargo_type'];
        $dateFrom  = $request['date_from'];
        $dateTo    = $request['date_to'];
        $countryId = $request['country_id'];
        
        $userId = $this->userId($request['user_id'], $page);
        
        
        if($type == 1):
           $table = 'courier_service';
           $field = 'total_price';
        elseif($type == 2):
            $table = 'cargo';
            $field = 'total';
        endif;
        
        $parcelInformation = \App\ParcelInformation::join($table, 'parcel_informations.id', '=', $table.'.parcel_information_id')
                                ->join('addresses', 'parcel_informations.delivery_id', '=', 'addresses.id')
                                ->select(['transaction_id', 'parcel_informations.created_at', 'tracking_number', 'parcel_contents', $field, 'status'])
                                ->where(function ($query) use($cargoType, $userId, $dateFrom, $dateTo, $countryId)
                                {
                                    if($cargoType != '')
                                    {
                                        $query->where('cargo_type', $cargoType);
                                    }

                                    if($userId != '')
                                    {
                                        $query->where('parcel_informations.user_id', $userId);
                                    }

                                    if($countryId != '')
                                    {
                                        $query->where('country_id', $countryId);
                                    }
                                    
                                    if($dateFrom != '' && $dateTo != '')
                                    {
                                        $from = $this->dateFrom($dateFrom);
                                        $to   = $this->dateTo($dateTo);
                                        $query->whereBetween('parcel_informations.created_at', array($from, $to));
                                    }
                                })->orderBy('created_at', 'desc');
            
        return Datatables::eloquent($parcelInformation)
            ->editColumn('status', function($parcelInformation) {
                if($parcelInformation->status == 0):
                    $status = '<button type="button" class="btn btn-warning btn-sm">Pending</button>';
                elseif($parcelInformation->status == 1):
                    $status = '<button type="button" class="btn btn-info btn-sm">Collected</button>';
                elseif($parcelInformation->status == 2):
                    $status = '<button type="button" class="btn btn-success btn-sm">Delivered</button>';
                endif;
                
                return $status;
//            })
//            ->addColumn('action', function($parcelInformation) use($page) {
                //return '<a href="'.URL::route('receipt', ['topup_id' => $topup->id, 'page' => $page]).'" data-toggle="modal" data-target="#receipt"><i class="fa fa-file-text-o"></i></a>';
            })->make(true);
    }
    
    public function mobileOrder(Request $request)
    {
        $title    = 'e-Mobile Report';
        $page     = $request['page'];
        $userId   = $request['user_id'];
        $userName = $request['user_name'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
        }
        
        return view('reports.mobile_order', compact('title', 'page', 'userId', 'userName', 'dateFrom', 'dateTo'));
    }
    
    public function getMobileOrderData(Request $request)
    { 
        $page     = $request['page'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];

        $userId = $this->userId($request['user_id'], $page);
        $from   = $this->dateFrom($dateFrom);
        $to     = $this->dateTo($dateTo);
        
        $mobileOrder = \App\MobileOrder::with('brand', 'model')->where(function ($query) use($userId)
            {
                if($userId != '')
                {
                    $query->where('user_id', $userId);
                }
            })->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'desc');
            
        return Datatables::eloquent($mobileOrder)
            ->editColumn('delivered', function($mobileOrder) {
                if($mobileOrder->delivered == 1)
                {
                    return 'YES';
                }else
                {
                    return 'NO';
                }
            })->make(true);
    }
    
    public function salesReport(Request $request)
    {
        $title        = 'Sales Report';
        $customerId   = $request['customer_id'];
        $customerName = $request['customer_name'];
        $dateFrom     = $request['date_from'];
        $dateTo       = $request['date_to'];
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
        }
        
        return view('reports.sales_report', compact('title' ,'customerId', 'customerName', 'dateFrom', 'dateTo'));
    }
    
    public function getSalesReportData(Request $request)
    {
        $customerId = $request['customer_id'];
        $dateFrom   = $request['date_from'];
        $dateTo     = $request['date_to'];

        $from = $this->dateFrom($dateFrom);
        $to   = $this->dateTo($dateTo);

        $where['status']  = 1;
        $where['user_id'] = userId();
        
        if($customerId != '')
        {
            $where['customer_id'] = $customerId;
        }
        
        $customerInvoice = CustomerInvoice::with('module')->where($where)->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'desc');

        return Datatables::eloquent($customerInvoice)
            ->addColumn('action', function($customerInvoice) {
                return '<a href="'.URL::route('customer_receipt', ['customer_invoice_id' => $customerInvoice->id]).'" data-toggle="modal" data-target="#receipt"><i class="fa fa-file-text-o"></i></a>';
            })->make(true);
    }
    
    public function simOrder(Request $request)
    {
        $title    = 'e-SIM Report';
        $page     = $request['page'];
        $userId   = $request['user_id'];
        $userName = $request['user_name'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
        }
        
        return view('reports.sim_order', compact('title', 'page', 'userId', 'userName', 'dateFrom', 'dateTo'));
    }
    
    public function getSimOrderData(Request $request)
    { 
        $page     = $request['page'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];

        $userId = $this->userId($request['user_id'], $page);
        $from   = $this->dateFrom($dateFrom);
        $to     = $this->dateTo($dateTo);
        
        $simOrder = \App\SimOrder::with('network')->where(function ($query) use($userId)
            {
                if($userId != '')
                {
                    $query->where('user_id', $userId);
                }
            })->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'desc');
            
        return Datatables::eloquent($simOrder)
           ->editColumn('delivered', function($simOrder) {
                if($simOrder->delivered == 1)
                {
                    return 'YES';
                }else
                {
                    return 'NO';
                }
            })->make(true);
    }
        
    public function topup(Request $request)
    {
        $category = $request['category'];
        
        if($category == 1):
            $title = 'e-TopUp Last 10 Transaction Report';
        else: 
            $title = 'e-Calling Card Last 10 Transaction Report';
        endif;        
        
        $topup = Topup::where(function ($query) use($category)
            {
                if($category == 1)
                {
                    $query->where('category_id', 1);
                }else
                {
                    $query->where('category_id', '!=', 1);
                }
                
                $where['user_id'] = userId();
                $query->where($where);
                
            })->orderBy('created_at', 'desc')->take(10)->get();
        
        return view('reports.topup', compact('title', 'category', 'topup'));
    }
    
    public function topupList(Request $request)
    {
        $page     = $request['page'];
        $category = $request['category'];
        $userId   = $request['user_id'];
        $userName = $request['user_name'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
     
        if($category == 1):
            $title = 'e-TopUp Report';
        else: 
            $title = 'e-Calling Card Report';
        endif;
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
        }
        
        return view('reports.topup_list', compact('title', 'page', 'category', 'userId', 'userName', 'dateFrom', 'dateTo'));
    }
    
    public function getTopupData(Request $request)
    { 
        $page     = $request['page'];
        $category = $request['category'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        $userId = $this->userId($request['user_id'], $page);
        $from   = $this->dateFrom($dateFrom);
        $to     = $this->dateTo($dateTo);
        
        $topup = Topup::with('pinNumber')->where(function ($query) use($category, $userId)
            {
                if($category == 1)
                {
                    $query->where('category_id', 1);
                }else
                {
                    $query->where('category_id', '!=', 1);
                }
                
                if($userId != '')
                {
                    $query->where('user_id', $userId);
                }
            })->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'desc');
            
        return Datatables::eloquent($topup, $page)
            ->editColumn('category_id', function ($topup) {
                return $topup->pinNumber->product->name;
            })
            ->addColumn('action', function($topup) use($page) {
                return '<a href="'.URL::route('receipt', ['topup_id' => $topup->id, 'page' => $page]).'" data-toggle="modal" data-target="#receipt"><i class="fa fa-file-text-o"></i></a>';
            })->make(true);
    }
    
    public function unlockingMobileStatus(Request $request)
    {
        $interval = getProfile()->page_refresh_time;
        $title = 'IMEI Order Status';
        $page  = $request['page'];
        
        $where['user_id'] = userId();
        
        $unlockingMobiles = UnlockingMobile::where($where)->where(function ($query)
            {
                $query->where('status', 0)->orWhere('status', 3);                
            })->orderBy('created_at', 'desc')->get();
        
        if($page == 3)
        {
            return view('reports.unlocking_mobile_child', compact('page', 'unlockingMobiles'));
        }else
        {
            return view('reports.unlocking_mobile', compact('title', 'page', 'unlockingMobiles', 'interval'));
        }
    }
    
    public function unlockingMobileList(Request $request)
    {
        $title    = 'e-Unlocking Mobile Report';
        $page     = $request['page'];
        $userId   = $request['user_id'];
        $userName = $request['user_name'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        if($dateFrom == '')
        {
            $dateFrom = date('d/m/Y');
        }
        
        if($dateTo == '')
        {
            $dateTo = date('d/m/Y');
        }
        return view('reports.unlocking_mobile_list', compact('title', 'page', 'userId', 'userName', 'dateFrom', 'dateTo'));
    }
    
    public function getUnlockingMobileData(Request $request)
    {
        $page     = $request['page'];
        $dateFrom = $request['date_from'];
        $dateTo   = $request['date_to'];
        
        $userId = $this->userId($request['user_id'], $page);
        $from   = $this->dateFrom($dateFrom);
        $to     = $this->dateTo($dateTo);

        $unlockingMobiles = UnlockingMobile::with('service')->where(function ($query) use($userId)
            {
                if($userId != '')
                {
                    $query->where('user_id', $userId);
                }
            })->whereBetween('created_at', array($from, $to))->orderBy('created_at', 'desc');


        return Datatables::eloquent($unlockingMobiles, $page)
            ->editColumn('response', function ($unlockingMobiles) {
                return preg_replace("/<A (HREF=\".*?\").*?>/", "<a $1 target=\"_blank\">", $unlockingMobiles->response);
            })
            ->editColumn('status', function ($unlockingMobiles) use($page) {
                if($unlockingMobiles->status == 1)
                {
                    $status = '<button class="btn btn-success btn-sm" type="button">Completed</button>';
                }elseif($unlockingMobiles->status == 2)
                {
                    $status = '<button class="btn btn-danger btn-sm" type="button">Rejected</button>';
                }elseif($unlockingMobiles->status == 3)
                {
                    if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
                    {
                        $status = '<a href="javascript:;" status="1" id="'.$unlockingMobiles->id.'" class="status">
                              <button type="button" class="btn btn-info btn-sm">In Process</button>
                            </a>';
                    }else
                    {
                        $status = '<button type="button" class="btn btn-info btn-sm">In Process</button>';
                    }
                    
                }elseif($unlockingMobiles->status == 4)
                {
                    $status = '<button class="btn btn-danger btn-sm" type="button">Cancelled</button>';
                }elseif($unlockingMobiles->status == 0)
                {
                    if($page == 2)
                    {
                        $status = '<a href="javascript:;" id="'.$unlockingMobiles->id.'" class="cancel">
                                <button type="button" class="btn btn-warning btn-sm">Cancel</button>
                            </a>';
                    }else
                    {
                        $status = '<button type="button" class="btn btn-warning btn-sm">Pending</button>';
                    }
                }
                
                return $status;
            })->make(true);
    }
    
    public function getUserData(Request $request)
    {
        $groupId = $request['groupId'];
        $where['activated'] = 1;
        $user =  User::with('userProfile')->whereHas('groups', function($query) use ($groupId)
            {
                $query->where('group_id', $groupId);
            })->where($where);

        return Datatables::eloquent($user)
            ->editColumn('id', function ($user) {
                {
                    return '<a href="javascript:;" class="user_details" id="'.$user->id.'|'.$user->userProfile->first_name.' '.$user->userProfile->last_name.'">'.$user->id.'</a>';
                }
            })->make(true);
    }
    
    private function dateFrom($dateFrom)
    {
        if($dateFrom == '')
        {
            $from = date('Y-m-d 00:00:00');
        }else
        {
            $from = getDateFrom($dateFrom);
        }
        
        return $from;
    }
    
    private function dateTo($dateTo)
    {
        if($dateTo == '')
        {
            $to = date('Y-m-d 23:59:59');
        }else
        {
            $to = getDateTo($dateTo);
        }
        
        return $to;
    }
    
    private function userId($userId, $page)
    {
        //Page 1 for Admin Page 2 for Agent
        if(userGroup() == 'agent')
        {
            $userId = userId();
        }else if($page == 2 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
        {
            $userId = userId();
        }
        
        return $userId;
    }
}
