<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\SimInformation;
use App\SimInformationData;

//use DateTime;
use Illuminate\Http\Request;
//use LaravelAcl\Authentication\Models\UserProfile;
use Session, Datatables;

class SimInformationsController extends Controller
{
//    public function __construct(Request $request)
//    {
//        if(!$request->ajax())
//        {
//            redirect('/admin')->send();
//        }
//    }
    
    //for list sim informations
    public function index()
    {
        $simInformation = SimInformation::select(\DB::raw('sim_informations.id, network_id, product_id, count(*) AS total, SUM(CASE WHEN agent_id != "" THEN 1 ELSE 0 END) AS allotted'))
                            ->join('sim_information_data', 'sim_informations.id', 'sim_information_data.sim_information_id')->groupBy('sim_information_id')->get();
        return view('sim_informations.index', compact('simInformation'));
    }
    
    //for create sim informations
    public function create(Request $request)
    {
        $id = $request['id'];
        
        $networkName = '';
        $productName = '';
                    
        if($id != '')
        {
            $simInformation = SimInformation::findOrFail($id);
            
            $networkName = $simInformation->network->name;
            $productName = $simInformation->product->name;
        }
        
        return view('sim_informations.create', compact('id', 'networkName', 'productName'));
    }

    //for store sim informations
    public function store(Request $request)
    {
        $simInformationId = $request['sim_information_id'];
        
        if($simInformationId == '')
        {
            $rules['network_id'] = 'required|unique:sim_informations,network_id,NULL,id,product_id,'.$request['product_id'];
            $rules['product_id'] = 'required';
        }
        
        $rules['ssn.*']        = 'required|digits_between:1,25|unique:sim_information_data,ssn';
        $rules['cli.*']        = 'digits_between:1,25|unique:sim_information_data,cli';
        $rules['expired_date'] = 'required';
                
        $this->validate($request, $rules);

        $request['user_id'] = userId();
        $requestData = $request->all();

        if($simInformationId == '')
        {
            $simInformation = SimInformation::create($requestData);
        }else
        {
            $simInformation = SimInformation::findOrFail($simInformationId);
        }
        
        foreach($request['ssn'] as $key => $value):
            $data[] = new SimInformationData(array(
                'ssn'          => $value,
                'cli'          => isset($request['cli'][$key])?$request['cli'][$key]:'',
                'expired_date' => getDate2($request['expired_date']),
                'user_id'      => userId()
            ));
        endforeach;

        $simInformation->simInformationData()->saveMany($data);

        Session::flash('flash_message', 'SIM Information added!');

        return response()->json(['response' => 'success']);
    }
    
    //for view sim informations
    public function show($id)
    {
        $simInformation = SimInformation::has('siminformationdata')->findOrFail($id);
        
        return view('sim_informations.show', compact('simInformation'));
    }
    
    //for product listing
    public function getSimProducts($networkId)
    {
        echo getSimProducts($networkId);
    }
    
    public function saleAgentSimAllotment()
    {
        return view('sim_informations.sale_agent_sim_allotment');
    }
    
    public function saleAgentSimAllotmentStore(Request $request)
    {
        $data['sale_agent_id'] = $request['user_id'];
        $data['sale_agent_allotment_date'] = date('Y-m-d H:i:s');
        
        SimInformationData::whereIn('ssn', $request['ssn'])->orWhereIn('cli', $request['ssn'])->update($data);

        Session::flash('flash_message', 'SIM Allotted Successfully!');

        return response()->json(['response' => 'success']);
    }
    
    public function agentSimAllotment()
    {
        return view('sim_informations.agent_sim_allotment');
    }
    
    public function agentSimAllotmentStore(Request $request)
    {
        $data['agent_id'] = $request['user_id'];
        $data['agent_allotment_date'] = date('Y-m-d H:i:s');
        
        SimInformationData::whereIn('ssn', $request['ssn'])->orWhereIn('cli', $request['ssn'])->update($data);

        Session::flash('flash_message', 'SIM Allotted Successfully!');

        return response()->json(['response' => 'success']);
    }
    
    public function getSsnInfo($type, $ssn)
    {
        if($type == 'ssn1')
        {
            $field = 'sale_agent_id';
        }else if($type == 'ssn2')
        {
            $field = 'agent_id';
        }
        
        $count = SimInformationData::whereNull($field)
            ->where(function($query) use ($ssn)
                {
                    $query->where('ssn', $ssn)->orWhere('cli', $ssn);
                })->count();
                
        echo $count;
    }
    
    //for sim information
    public function getSimInformations()
    {
        $check = $where['user_id'] = userId();
        return view('sim_informations.simchecksum', compact('check'));
    }
    //for Sim Information check
    public function getCliChecksum(Request $request)
    {
        $check = $where['user_id'] = userId();
        $cli = $request['cli'];
        $simInformationData = SimInformationData:: where('cli',$cli)->first();
        $sim_information_id = $simInformationData->sim_information_id;
        $simInformation = SimInformation::where('id',$sim_information_id)->first();

        return view('sim_informations.simchecksuminfo',compact('simInformationData','simInformation','check'));
    }
}
