<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use DateTime;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use App\Banking;
use App\Category;
use App\PinNumber;
use App\Product;
use App\Service;
use App\MnrService;
use App\Topup;
use App\UserBalance;
use App\UnlockingMobile;
use App\SimInformationData;
use App\ParcelInformation;
use App\Address;
use App\Customer;
use Illuminate\Http\Request;
use Session, DB, Form, URL, Twilio, Curl;
use Artisaninweb\SoapWrapper\SoapWrapper;

class TransactionsController extends Controller
{
    public function attractions(Request $request)
    {        
        $title = 'e-Attractions';
        $moduleId     = 1;
        $costPrice    = getGlobalValue('e-attractions_commission');
        $customerId   = $request['customer_id'];
        $customerName = $request['customer_name'];
        
        return view('transactions.attractions', compact('title', 'moduleId', 'costPrice', 'customerId', 'customerName'));
    }
    
    public function banking(Request $request)
    {
        $title = 'e-Banking';
        $bank_id = $request['bank_id'];
        
        if($bank_id == 0)
        {
            $where['user_id'] = userId();
            $banking = Banking::where($where)->get();
        }else
        {
            $where['bank_id'] = $bank_id;
            $banking = \App\BankAccount::where($where)->get()->first();
        }
        
        return view('transactions.banking', compact('title', 'bank_id', 'banking'));
    }

    public function bankingStore(Request $request)
    {
        $this->validate($request, [
            'date'        => 'required',//|date
            'bank_id'     => 'required',
            'amount'      => 'required|numeric',
            'payment_ref' => 'required'
        ]);
        
        $request['transaction_id'] = getAgentTransactionId();
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        $banking = Banking::create($requestData);
        
        $data['amount']  = $request['amount'];
        $data['action']  = 'Payment By Banking';
        $data['user_id'] = userId();

        UserBalance::create($data);
        
        $this->sendBankingEmail($banking);
        
        Session::flash('flash_message', 'Banking added and will be approved by admin!');

        return response()->json(['response' => 'success']);
    }
    
    public function commissionScheme()
    {
        $title = 'Commission Scheme';
        $profile = getProfile();
        $where['id'] = $profile->network_commission_id;
        $networkCommission = \App\NetworkCommission::where($where)->first();
        
        $where_1['network_commission_id'] = $profile->network_commission_id;
        
        $networkCommissionScheme = \App\NetworkCommissionScheme::where($where_1)->orderBy('sort_order', 'Asc')->orderBy('network_id', 'Asc')->orderBy('topup_level', 'Asc')->get();

        return view('transactions.commission_scheme', compact('title', 'networkCommission', 'networkCommissionScheme'));
    }
    
    public function cargoServiceCoverPage()
    {
        $title = 'e-Cargo Service';
        return view('transactions.cargo_service_cover_page', compact('title'));
    }
    
    public function courierService(Request $request)
    {
        $cargoType = '';
        $type = $request['type'];
        
        if($type == 1):
           $title = 'e-Courier Service';
        elseif($type == 2):
            $cargoType = $request['cargo_type'];
            if($cargoType == 1):
                $title = 'Air Cargo';
            elseif($cargoType == 2):
                $title = 'Sea Cargo';
            endif;
        endif;
            
        return view('transactions.courier_service', compact('title', 'type', 'cargoType'));
    }
    
    public function courierServiceDetail(Request $request)
    {
        $rule = ($request['collection_table_id'] == 2)?'|different:delivery_id':'';
        
        $this->validate($request, [
            'collection_country_id' => 'required_if:type,2',
            'delivery_country_id'   => 'required_if:type,2',
            'cargo_service_id'      => 'required_if:type,2',
            'cargo_service_rate_id' => 'required_if:type,2',
            'cargo_rate'            => 'required_if:type,2',
            'parcel_contents'       => 'required|alpha_dash_space|max:100',
            'estimated_value'       => 'required|numeric',
            'item_name.*'           => 'required|alpha_dash_space|max:100',
            'weight.*'              => 'required|numeric',
            'dim1.*'                => 'required|numeric',
            'dim2.*'                => 'required|numeric',
            'dim3.*'                => 'required|numeric',
            'collection_id'         => 'required'.$rule,
            'collection_table_id'   => 'required',
            'delivery_id'           => 'required'
        ]);    
        
        $totalPrice        = 0;
        $type              = $request['type'];
        $collectionId      = $request['collection_id'];
        $collectionTableId = $request['collection_table_id'];
        $deliveryId        = $request['delivery_id'];
        $customerId        = $request['customer_id'];        
        $customerName      = $request['customer_name'];
        
        if($collectionTableId == 1)
        {
            $collectionCount = \App\UserProfile::where('user_id', userId())->whereNotNull('first_name')->whereNotNull('last_name')->whereNotNull('address')->
                                        whereNotNull('zip')->whereNotNull('business_no')->count();
        }else if($collectionTableId == 2)
        {
            $collectionCount = Address::where('id', $collectionId)->whereNotNull('first_name')->whereNotNull('last_name')->whereNotNull('address_line_1')->
                                        whereNotNull('town')->whereNotNull('county')->whereNotNull('post_code')->whereNotNull('phone_no')->whereNotNull('country_id')->count();
        }
        
        $deliveryCount = Address::where('id', $deliveryId)->whereNotNull('first_name')->whereNotNull('last_name')->whereNotNull('address_line_1')->
                                        whereNotNull('town')->whereNotNull('county')->whereNotNull('post_code')->whereNotNull('phone_no')->whereNotNull('country_id')->count();
        
        if($collectionCount == 0)
        {
            return response()->json(['message' => 'Missing Fileds in Collection Address']);
        }else if($deliveryCount == 0)
        {
            return response()->json(['message' => 'Missing Fileds in Delivery Address']);
        }else
        {
            if($type == 2)
            {
                $cargoType = $request['cargo_type'];
                $cargoRate = $request['cargo_rate'];
                if($cargoType == 1)
                {
                    $title = 'Air Cargo';
                }else if($cargoType == 2)
                {
                    $title = 'Sea Cargo';
                }
            }
            
            foreach($request['weight'] as $key => $value):

                if($type == 1)
                {
                    $parcelData[] = $value.','.$request['dim1'][$key].','.$request['dim2'][$key].','.$request['dim3'][$key].','.$request['item_name'][$key];
                }
                else if($type == 2)
                {
                    $parcelData[] = array('item' => $request['item_name'][$key], 'weight' => $value, 'dim1' => $request['dim1'][$key], 'dim2' => $request['dim2'][$key], 'dim3' => $request['dim3'][$key]);
                   
                    $price = $cargoRate * $request['weight'][$key];

                    $totalPrice = $totalPrice + $price;
                }
            endforeach;

            if($type == 1)
            {
                $addressLine2 = '';
                $addressLine3 = '';
                $country = 'GB';

                if($collectionTableId == 1)
                {
                    $address = getProfile();

                    $addressLine1 = $address->address;
                    $postCode     = $address->zip;    
                    $phoneNo      = $address->business_no;
                }else if($collectionTableId == 2)
                {
                    $address = Address::where('id', $collectionId)->first();

                    $addressLine1 = $address->address_line_1;
                    $addressLine2 = $address->address_line_2;
                    $addressLine3 = $address->address_line_3;
                    $postCode     = $address->post_code;    
                    $phoneNo      = $address->phone_no;
                    $country      = $address->country->sortname;
                }

                $delivery_address = Address::where('id', $deliveryId)->first();

                $title = 'e-Courier Service List';

                $data['ShipAction']          = 'GetQuote';
                $data['Username']            = 'it@mnrworldwide.com';
                $data['APIKey']              = '4L1KUZYG8UXYFRYC6MD';	
                $data['CollectionName']      = $address->first_name.' '.$address->last_name;
                $data['CollectionCompany']   = $address->company;
                $data['CollectionAddress1']  = $addressLine1; 	
                $data['CollectionAddress2']  = $addressLine2; 	
                $data['CollectionAddress3']  = $addressLine3; 	 	 
                $data['CollectionTown']      = $address->town; 	
                $data['CollectionCounty']    = $address->county;
                $data['CollectionPostcode']  = $postCode;
                $data['CollectionTelephone'] = $phoneNo;
                $data['CollectionCountry']   = $country; 
                $data['DeliveryName']        = $delivery_address->first_name.' '.$delivery_address->last_name;
                $data['DeliveryCompany']     = $delivery_address->company;
                $data['DeliveryAddress1']    = $delivery_address->address_line_1;
                $data['DeliveryAddress2']    = $delivery_address->address_line_2;
                $data['DeliveryAddress3']    = $delivery_address->address_line_3;
                $data['DeliveryTown']        = $delivery_address->town;
                $data['DeliveryCounty']      = $delivery_address->county;
                $data['DeliveryPostcode']    = $delivery_address->post_code;
                $data['DeliveryCountry']     = $delivery_address->country->sortname;
                $data['DeliveryTelephone']   = $delivery_address->phone_no;
                $data['ParcelData']          = join('|', $parcelData);
                $data['ParcelContents']      = $request['parcel_contents'];
                $data['EstimatedValue']      = $request['estimated_value'];

                $response = Curl::to('https://www.p4d.co.uk/p4d/api/v2')->withData($data)->post();

                $jsonArray = json_decode($response, true); 

                return view('transactions.courier_service_detail', compact('title', 'collectionId', 'collectionTableId', 'deliveryId', 'customerId', 'customerName', 'jsonArray'));
            }else if($type == 2)
            {
                if($totalPrice < getClientLimit())
                {
                    $transactionId = getAgentTransactionId();

                    $request['bundle_data']         = \json_encode($parcelData);
                    $request['collection_id']       = $collectionId;
                    $request['collection_table_id'] = $collectionTableId;
                    $request['delivery_id']         = $deliveryId;
                    $request['transaction_id']      = $transactionId;
                    $request['user_id']             = userId();

                    $requestData = $request->all();

                    $parcelInformation = ParcelInformation::create($requestData);

                    $data['cargo_type'] = $cargoType;
                    $data['cargo_service_id'] = $request['cargo_service_id'];
                    $data['cargo_service_rate_id'] = $request['cargo_service_rate_id'];
                    $data['rate'] = $cargoRate;
                    $data['total'] = $totalPrice;
                    $data['parcel_information_id'] = $parcelInformation->id;
                    \App\Cargo::create($data);
                    
                    $action = $title.' Service (Transaction ID : '.$transactionId.')';
                    
                    $this->deductBalance($totalPrice, $action);
                    
                    Session::flash('flash_message', 'Parcel is booked Successfully!');
                    return response()->json(['response' => 'success', 'customer_id' => $customerId, 'customer_name' => $customerName, 'module_id' => 6, 'id' => $parcelInformation->id]);
                }else
                {
                    return response()->json(['message' => 'Not Enough Balance..!']);
                }
            }
        }
    }
        
    public function courierServiceStore(Request $request)
    {
        $this->validate($request, [
            'quote_id'            => 'required',
            'item_id'             => 'required',
            'collection_date'     => 'required',            
            'sub_total'           => 'required|numeric',
            'vat_total'           => 'required|numeric',
            'total_price'         => 'required|numeric|max:'.getClientLimit(),
            'collection_id'       => 'required',
            'collection_table_id' => 'required',
            'delivery_id'         => 'required'
        ]);
        
        $data['ShipAction']     = 'PlaceBooking';
        $data['Username']       = 'it@mnrworldwide.com';
        $data['APIKey']         = '4L1KUZYG8UXYFRYC6MD';
        $data['QuoteID']        = $request['quote_id'];
        $data['ItemID']         = $request['item_id'];
        $data['CollectionDate'] = $request['collection_date'];
        
//        $placeBookingResponse = Curl::to('https://www.p4d.co.uk/p4d/api/v2')->withData($data)->post();
        $placeBooking = json_decode($placeBookingResponse, true);
        
        unset($data['ItemID']);
        unset($data['CollectionDate']);
        
        $response['transaction_id'] = $placeBooking['TransactionID'];
        $response['response']       = $placeBookingResponse;
        $response['api']            = 'p4d';
        $response['user_id']        = userId();

        \App\ApiResponse::create($response);
                        
        if($placeBooking['Status'] == 'Success')
        {             
            $data['ShipAction'] = 'QuoteInformation';
       
            $quoteInfoResponse = Curl::to('https://www.p4d.co.uk/p4d/api/v2')->withData($data)->post();

            $quoteInfo = json_decode($quoteInfoResponse, true);
        
            $orderNo = $placeBooking['OrderNumber'];
            $totalPrice = $request['total_price'];
            $transactionId = getAgentTransactionId();
            
            $request['parcel_contents'] = $quoteInfo['ParcelContents'];
            $request['estimated_value'] = $quoteInfo['EstimatedValue'];
            $request['bundle_data']     = json_encode($quoteInfo['Parcels']);
            $request['transaction_id']  = $transactionId;
            $request['type']            = 1;
            $request['user_id']         = userId();

            $parcelInformation = ParcelInformation::create($request->all());
            
            $request['order_number'] = $orderNo;
            $request['parcel_information_id'] = $parcelInformation->id;
            \App\CourierService::create($request->all());
            
            $action = 'Courier Service (Transaction ID : '.$transactionId.')';
            
            $this->deductBalance($totalPrice, $action);
            
            Session::flash('flash_message', 'Parcel is booked Successfully!');
            
            return response()->json(['response' => 'success', 'customer_id' => $request['customer_id'], 'customer_name' => $request['customer_name'], 'module_id' => 5, 'id' => $parcelInformation->id]);
        }else
        {
            return response()->json(['message' => 'Parcel is not booked Successfully!']);
        }
    }
    
    private function courierSoapAdd()
    {
        $this->soapWrapper->add('Parcel2go', function ($service) {
            $service
            ->wsdl('https://v3.api.parcel2go.com/ParcelService.asmx?WSDL')
            ->trace(true);
        });
    }
    
    public function courierInfo(Request $request)
    {
        $type        = $request['type'];
        $serviceName = $request['service_name'];
        $printer     = $request['printer'];
        
        return view('transactions.courier_info', compact('type', 'serviceName', 'printer'));
    }    
   
    public function filterCourierAddresses(Request $request)
    {
        $id          = $request['id'];
        $addressType = $request['address_type'];
        $customerId  = $request['customer_id'];
        $countryId   = $request['country_id'];
        
        if($id != '')
        {
            $where['id'] = $id;
        }else
        {
            $where['customer_id'] = $customerId;
        }
        
        $where['country_id'] = $countryId;
        $where['user_id'] = userId();
        
        $addresses = Address::where($where)->orderBy('default_address', 'DESC')->get();
      
        return view('transactions.filter_courier_addresses', compact('addressType', 'addresses'));
    }   
    
    public function courierAddress(Request $request)
    {
        $id    = $request['id'];
        $table = $request['table']; //Table User Profile 1, Table Addresses 2 
        
        $countries    = '';
        $firstName    = '';
        $lastName     = '';
        $company      = '';
        $addressLine1 = '';
        $addressLine2 = '';
        $addressLine3 = '';
        $town         = '';
        $county       = '';
        $postCode     = '';    
        $phoneNo      = '';
        $phoneNo1     = '';
        $phoneNo2     = '';
        $countryId    = $request['country_id'];
        $customerId   = $request['customer_id'];
        
        if($table == 1)
        {
            $userProfile = getProfile();

            $id           = $userProfile->id;
            $firstName    = $userProfile->first_name;
            $lastName     = $userProfile->last_name;
            $company      = $userProfile->company;
            $addressLine1 = $userProfile->address;
            $town         = $userProfile->town;
            $county       = $userProfile->county;
            $postCode     = $userProfile->zip;    
            $phoneNo      = $userProfile->business_no;
            $countryId    = 230;
        }else if($table == 2)
        {
            $address = Address::where('id', $id)->first();

            $id           = $address->id;
            $firstName    = $address->first_name;
            $lastName     = $address->last_name;
            $company      = $address->company;
            $addressLine1 = $address->address_line_1;
            $addressLine2 = $address->address_line_2;
            $addressLine3 = $address->address_line_3;
            $town         = $address->town;
            $county       = $address->county;
            $postCode     = $address->post_code;    
            $phoneNo      = $address->phone_no;
            $phoneNo1     = $address->phone_no_1;
            $phoneNo2     = $address->phone_no_2;
            $countryId    = $address->country_id;
            $customerId   = $address->customer_id;
        }
/*        
        if($type == 1)
        {
            $reqData = array(
                    'ShipAction' => 'GetCountries',
                    'Username'   => 'it@mnrworldwide.com',
                    'APIKey'     => '4L1KUZYG8UXYFRYC6MD'
                );

            $response = Curl::to('https://www.p4d.co.uk/p4d/api/v2')->withData($reqData)->post();

            $jsonArray = json_decode($response, true);

            $countries = $jsonArray['Countries'];
        }
*/        
        $data['address_type']   = $request['address_type'];
        $data['customer_id']    = $customerId;
        $data['table_id']       = $table;
        $data['id']             = $id;
        $data['first_name']     = $firstName;
        $data['last_name']      = $lastName;
        $data['company']        = $company;
        $data['address_line_1'] = $addressLine1;
        $data['address_line_2'] = $addressLine2;
        $data['address_line_3'] = $addressLine3;
        $data['town']           = $town;
        $data['county']         = $county;
        $data['post_code']      = $postCode;    
        $data['phone_no']       = $phoneNo;
        $data['phone_no_1']     = $phoneNo1;
        $data['phone_no_2']     = $phoneNo2;
        $data['country_id']     = $countryId;
        
        return view('transactions.courier_address_modal', compact('countries', 'data'));
    }
    
    public function courierAddressStore(Request $request)
    {
        $this->validate($request, [
            'id'             => 'required_if:table_id,1,2',
            'table_id'       => 'required',
            'address_type'   => 'required',
            'first_name'     => 'required|alpha_dash_space|max:50',
            'last_name'      => 'required|alpha_dash_space|max:50',
            'company'        => 'alpha_dash_space|max:100',
            'address_line_1' => 'required|max:255',
            'address_line_2' => 'max:255',
            'address_line_3' => 'max:255',
            'town'           => 'required|max:100',
            'county'         => 'required|max:100',
            'post_code'      => 'required|max:20',
            'phone_no'       => 'required|digits_between:1,20',
            'phone_no_1'     => 'digits_between:1,20',
            'phone_no_2'     => 'digits_between:1,20',
            'country_id'     => 'required'
        ]);

        $id = $request['id'];
        $table = $request['table_id'];
        $addressType = $request['address_type'];
        $customerId  = $request['customer_id'];
        $countryId   = $request['country_id'];
        $customerName = '';
        
        if($table == 0)
        {
            $request['user_id'] = userId();
            
            if($addressType == 1)
            {
                $request['default_address'] = 1;
                $customer = Customer::create($request->all());
                $customerId = $customer->id;
                $customerName = $customer->first_name.' '.$customer->last_name;
            }
            
            $request['customer_id'] = $customerId;
            
            $address = Address::create($request->all());
            $id = $address->id;
        }else
        {
            if($table == 1)
            {
                $request['address']     = $request['address_line_1'];
                $request['zip']         = $request['post_code'];
                $request['business_no'] = $request['phone_no'];
                
                $userProfile = \App\UserProfile::findOrFail($id);
                $userProfile->update($request->all());
            }  else {
                $address = Address::findOrFail($id);
                $address->update($request->all());
            }
        }
        
        return response()->json(['response' => 'success', 'module' => 'courier_address', 'address_type' => $addressType, 'table' => $table, 'id' => $id, 'customer_id' => $customerId, 'customer_name' => $customerName, 'country_id' => $countryId]);
    }
    
    public function courierUserProfile()
    {
        return view('transactions.courier_user_profile');
    }
    
    public function getDeliveryCountries(Request $request)
    {
        $cargoType = $request['cargo_type'];
        $countryId = $request['country_id'];
        echo getDeliveryCountries($cargoType, $countryId);
    }
    
    public function getCargoServices(Request $request)
    {
        $cargoType = $request['cargo_type'];
        $collectionCountryId = $request['collection_country_id'];
        $deliveryCountryId = $request['delivery_country_id'];
        
        echo getCargoServices2($cargoType, $collectionCountryId, $deliveryCountryId);
    }
    
    public function getCargoRate(Request $request)
    {
        $where['cargo_type'] = $request['cargo_type'];
        $where['collection_country_id'] = $request['collection_country_id'];
        $where['delivery_country_id'] = $request['delivery_country_id'];
        $where['cargo_service_id'] = $request['cargo_service_id'];
        
        $cargoServiceRate = \App\CargoServiceRate::select('id', 'rate')->where($where)->first();
        
        return response()->json(['id' => $cargoServiceRate->id, 'rate' => $cargoServiceRate->rate]);
    }

    public function hotels(Request $request)
    {
        $title = 'e-Hotels';
        $moduleId     = 7;
        $costPrice    = getGlobalValue('e-hotels_commission');
        $customerId   = $request['customer_id'];
        $customerName = $request['customer_name'];
        
        return view('transactions.hotels', compact('title', 'moduleId', 'costPrice', 'customerId', 'customerName'));
    }
    
    public function instantCredit()
    {
        $title = 'Instant Credit';
        return view('transactions.instant_credit', compact('title'));
    }
    
    public function instantCreditStripeReceipt()
    {
        $date       = '';
        $creditCard = '';
        $amount     = 0;
        $charges    = 0.00;
        
        if (Session::has('transaction_id')):
            
            $where['transaction_id'] = Session::get('transaction_id');
            $where['user_id'] = userId();
            
            $paymentMethodResponse = \App\PaymentMethodResponse::where($where)->first();
            
            $response = json_decode($paymentMethodResponse->response);     
                       
            $date = date('d/m/Y H:i:s', $response->created);
            $creditCard = '************'.$response->source->last4;
            $amount = $response->amount / 100;
            
        endif;
        
        return view('transactions.instant_credit_stripe_receipt', compact('date', 'creditCard', 'amount', 'charges'));
    }
    
    public function internationalTopup()
    {
        $title = 'e-International Top-Up';
        return view('transactions.international_topup', compact('title'));
    }
    
    public function mnrServices(Request $request)
    {
        $type = $request['type'];
        
        if($type == 1):
            $title = 'MNR e-Services';
        elseif($request['type'] == 2):
            $title = 'MNR e-Marketing';
        endif;
            
        $where['status'] = 1;
        $where['type'] = ($type == 1)?4:5;
        
//        $categories = Category::where($where)->orderBy('sort_order', 'Asc')->get();
        
        $categories = Category::whereHas('mnrservices', function($query) use ($request) 
        {
            $query->where(array('status' => 1, 'type' => $request['type']));
            
            if($request['category_id'] != '')
            {
                $query->whereIn('category_id', $request['category_id']);
            }
        })->where($where)->orderBy('sort_order', 'Asc')->get();

        return view('transactions.mnr_services', compact('title', 'request', 'categories'));
    }
    
    public function mnrServiceDetail(Request $request)
    {
        $title = 'MNR e-Service Refer';
        
        $where['id'] = $request['service_id'];
        
        $mnrService = MnrService::where($where)->first();
        
        return view('transactions.mnr_service_detail', compact('title', 'mnrService'));
    }
    
    public function mnrServiceStore(Request $request)
    {        
        $this->validate($request, [
            'service_id' => 'required',
            'first_name' => 'required|alpha_dash_space|max:50',
            'last_name'  => 'required|alpha_dash_space|max:50',
            'email'      => 'required|email|unique:referral_users',
            'phone_no'   => 'required|digits_between:1,20',
            'mobile_no'  => 'required|digits_between:1,20'
        ]);
        
        $request['transaction_id'] = getAgentTransactionId();
        $request['user_id'] = userId();
        $requestData = $request->all();
        
        \App\ReferralUser::create($requestData);
        
        Session::flash('flash_message', 'Your request has been received and will be processed shortly');
        
        return response()->json(['response' => 'success']);
    }
    
    public function mobileOrder()
    {
        $title = 'e-Mobile Order';
        return view('transactions.mobile_order', compact('title'));
    }

    public function mobileOrderStore(Request $request)
    {
        $grantTotal = 0;
        $transactionId = getAgentTransactionId();

        $this->validate($request, [
            'brand_ids.*'      => 'required',
            'model_ids.*'      => 'required',
            'product_types.*'  => 'required',            
            'quantities.*'     => 'required',
            'prices.*'         => 'required',
            'total.*'          => 'required',
            'grant_total'      => 'required|numeric|max:'.getClientLimit(),
        ]);
        
        $brandId     = $request['brand_ids'];
        $modelId     = $request['model_ids'];
        $productType = $request['product_types'];
        $quantity    = $request['quantities'];
        $price       = $request['prices'];
        $total       = $request['total'];
        
        foreach ($brandId as $key => $value):
          
            $data[] = array(
                'brand_id'       => $value,
                'model_id'       => $modelId[$key],
                'product_type'   => $productType[$key],
                'quantity'       => $quantity[$key],
                'price'          => $price[$key],
                'total'          => $total[$key],
                'transaction_id' => $transactionId,
                'user_id'        => userId(),
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s')
            );
           
            $grantTotal = $grantTotal + $total[$key];
        endforeach;
        
        \App\MobileOrder::Insert($data);
        
        $action = 'Mobile Order (Order No: '.$transactionId.')';

        $this->deductBalance($grantTotal, $action);
        
        Session::flash('flash_message', 'Your Order Number is: '.$transactionId.' .Thanks for your order. Your order will be delivered to you in next 48 hrs.');
        
        return response()->json(['response' => 'success']);
    }
/*    
    public function getModels($brandId)
    {
        echo getModels($brandId);
    }
*/    
    function getProductDetail(Request $request)
    {
        if($request['model_id'] != '')
        {
            $where['id'] = $request['model_id'];
            $where['status'] = 1;

            $product = \App\MobileProduct::where($where)->first();

            if(count($product) > 0)
            {
                $new = ($request['quantity_type'] == 1)?TRUE:FALSE;
                $refurb = ($request['quantity_type'] == 2)?TRUE:FALSE;
                $quantity = ($request['quantity'] > 0)?$request['quantity']:1;

                if($product->new_quantity > 0)
                {
                    $quantityType = '<label class="mt-radio mt-radio-outline">'.
                        Form::radio('quantity_type', 1, $new, array('id' => 'new', 'class' => 'quantity_type')).' New
                        <span></span>
                    </label>';
                }  else {
                    $quantityType = '<label class="mt-radio">'.
                        Form::radio('', '', false, array('disabled' => true)).' New
                        <span></span>
                    </label>';
                }

                if($product->refurb_quantity > 0)
                {
                    $quantityType .= '<label class="mt-radio mt-radio-outline">'.
                        Form::radio('quantity_type', 2, $refurb, array('id' => 'refurb', 'class' => 'quantity_type')).' Refurb
                        <span></span>
                    </label>';
                }else
                {
                    $quantityType .= '<label class="mt-radio">'.
                        Form::radio('', '', false, array('disabled' => true)).' Refurb
                        <span></span>
                    </label>';
                }
                if($request['quantity_type'] == 1 || $request['quantity_type'] ==  2)
                {
                    if($request['quantity_type'] == 1)
                    {
                        $field = 'new_quantity';
                    }else if($request['quantity_type'] ==  2)
                    {
                        $field = 'refurb_quantity';
                    }

                    $quantityRange = Form::selectRange('quantity', 1, $product->$field, $quantity, ['id' => 'quantity', 'class' => 'form-control select2']);

                }else
                {
                    $quantityRange = Form::select('quantity', 
                            ['' => 'Select Quantity'], null, [
                                'id' => 'quantity', 'class' => 'form-control select2'
                            ]);
                }

                if($product->image_name != '')
                {
                    $image = '<img src="'.URL::asset('/images/mobile_images/'.$product->image_name.'?'.time()).'" border="1" width="180">';
                }else{
                    $image = '<img src="'.URL::asset('/packages/mnr_ehub/img/no-image.jpg').'" border="1" width="180">';
                }

                $html = '<div class="col-md-7">
                    <div class="form-group margin-top-20">
                        <div class="col-md-12">'.
                           getBrands($request['brand_id'])
                        .'</div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">'.
                            getModels($request['brand_id'], $request['model_id'])
                        .'</div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div id="quantity_type" class="mt-radio-inline">'.
                                $quantityType
                            .'</div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">'.
                            $quantityRange
                        .'</div>
                    </div>';
                if($request['quantity_type'] == 1 || $request['quantity_type'] ==  2)
                {
                    $priceDetail = '<div class="row static-info">
                            <div class="col-md-8 name"> Rate(Inc.VAT): </div>
                            <div class="col-md-4 value">'.getGlobalValue('currency').$product->price.'</div>'.
                            Form::hidden('price', $product->price, ['id' => 'price'])    
                        .'</div>
                        <div class="row static-info">
                            <div class="col-md-8 name"> QTY: </div>
                            <div class="col-md-4 value">'.$quantity.'</div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-8 name"> Total Price: </div>
                            <div class="col-md-4 value">'.getGlobalValue('currency').$quantity * $product->price.'</div>
                        </div>';
                }else
                {
                    $priceDetail = '';
                }
                $html .= $priceDetail;
                $html .= '<div class="form-group">
                        <div class="col-md-6">'.
                            Form::button('Add to Cart', ['id' => 'add_to_cart', 'class' => 'btn dark'])
                        .'</div>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="form-group margin-top-20">'.$image.'</div>
                </div>';
                
                echo $html;
            }else{
                $brandId = $request['brand_id'];
                return view('transactions.mobile_order_child', compact('brandId'));
            }
        }  else {
            $brandId = $request['brand_id'];
            return view('transactions.mobile_order_child', compact('brandId'));
        }
    }
    
    public function simCoverPage()
    {
        $title = 'e-SIM';
        $userId = userId();
        $count_supplied_sim = SimInformationData::where('agent_id',$userId)->groupBy(\DB::raw('EXTRACT(MONTH FROM created_at)'))->count();
        $createdAt = Carbon::parse($count_supplied_sim['created_at']);
        $month_actual = $createdAt->format('m');
        $year_actual = $createdAt->format('Y');
        $month_pervious = $month_actual-0;
        $month_pervious_active = $month_actual-0;
        $dateObjSim   = DateTime::createFromFormat('!m', $month_pervious);
        $dateObjActive   = DateTime::createFromFormat('!m', $month_pervious_active);
        $monthNameSimSupplied = $dateObjSim->format('F');
        $monthNameSimActive = $dateObjActive->format('F');
        $where['category_id'] = 4;

        $products = Product::where($where)->get();

        return view('transactions.sim_cover_page', compact('title', 'products','count_supplied_sim','year_actual','monthNameSimSupplied','monthNameSimActive'));
    }
    
    public function simOrder()
    {
        $title = 'e-SIM Order';
        $where['status'] = 1;
        $networks = \App\Network::where($where)->get();

        return view('transactions.sim_order', compact('title', 'networks'));
    }

    public function simOrderStore(Request $request)
    {
//        $this->validate($request, [
//            'product_id.*' => 'required'
//        ]);
        $transactionId = getAgentTransactionId();
        $network_id = $request['network_id'];
        $quantity   = $request['quantity'];
        
        foreach ($network_id as $key => $value):
          
            $data[] = array(
                'network_id'     => $value,
                'quantity'       => $quantity[$key],
                'transaction_id' => $transactionId,
                'user_id'        => userId(),
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s')
            );
           
        endforeach;
        
        \App\SimOrder::Insert($data);
        
        Session::flash('order_no', $transactionId);
        
        return response()->json(['response' => 'success']);
    }
    
    public function ticket(Request $request)
    {
        $title = 'e-Ticket';
        $moduleId     = 13;
        $costPrice    = getGlobalValue('e-ticket_commission');
        $customerId   = $request['customer_id'];
        $customerName = $request['customer_name'];
        
        return view('transactions.ticket', compact('title', 'moduleId', 'costPrice', 'customerId', 'customerName'));
    }
    
    public function tours(Request $request)
    {
        $title = 'e-Tours';
        $moduleId     = 14;
        $costPrice    = getGlobalValue('e-tours_commission');
        $customerId   = $request['customer_id'];
        $customerName = $request['customer_name'];
        
        return view('transactions.tours', compact('title', 'moduleId', 'costPrice', 'customerId', 'customerName'));
    }
    
    public function topup(Request $request)
    {
        $topup = $request['category'];
        
        if($topup == 1):
            $title = 'e-Top-Up';
        else:
            $title = 'e-Calling Card';
        endif;
                
        return view('transactions.topup', compact('title', 'topup'));
    }

    public function topupStore(Request $request)
    {
        $amount = $request['amount'];
        $sendPinMethod = $request['send_pin_method'];
        
        $this->validate($request, [
            'category_id'     => 'required',
            'product_id'      => 'required',
            'amount'          => 'required|numeric|max:'.getClientLimit(),
            'send_pin_method' => 'required'
        ]);
        
        $where['status']     = 1;
        $where['amount']     = $amount;
        $where['product_id'] = $request['product_id'];
        $pinNumber = PinNumber::where($where)->where('expired_date', '>=', date('Y-m-d'))->orderBy('expired_date', 'ASC')->first();
        
        $product = $pinNumber->product->amounts()->where('amount', $amount)->first();
        $agentPrice = $product->pivot->agent_price;
        
        $pinId    = $pinNumber->id;
        $pinNo    = $pinNumber->pin_number;
        $serialNo = $pinNumber->serial_number;
        
        $request['pin_number_id']  = $pinId;
        $request['transaction_id'] = getTransactionId();
        $request['agent_transaction_id'] = getAgentTransactionId();
        $request['user_id'] = userId();
        $requestData = $request->except(['product_id']);
        
        $topup = Topup::create($requestData);
        
        PinNumber::where('id', $pinId)->update(array('status' => 2));//used

        $action = $topup->category->name.' ('.$topup->pinNumber->product->name.')';
        
        $this->deductBalance($agentPrice, $action);
        
        $userName = getUserName($topup);
        
        if($sendPinMethod == 'email')
        {
            $email = $request['contact_info'];
            $mailer = \App::make('jmailer');

            $viewFile = "mail.pin_number";

            // send email to client
            $mailer->sendTo($email, [
                    'user_name'     => $userName,
                    'created_at'    => $topup->created_at,
                    'product_name'  => $topup->pinNumber->product->name,
                    'amount'        => $amount,
                    'pin_number'    => $pinNo,
                    'serial_number' => $serialNo,
                    'description'   => $topup->pinNumber->product->description
                ],
                'Pin Number', $viewFile);
        }else if($sendPinMethod == 'sms')
        {
            $mobile = $request['contact_info'];
            $message = 'Customer Information\n
                            Date: '.$topup->created_at.'\n
                            Loc: 5916182127(Static)\n
                            Mac: 001B2159BFDA(Static)\n
                            Product: '.$topup->pinNumber->product->name.'\n
                            Value: '.getGlobalValue('currency').$topup->amount.'\n
                            Pin: '.$topup->pinNumber->pin_number.'\n
                            Serial: '.$serialNo.'\n'.
                            $topup->pinNumber->product->description;
            
            $result = Twilio::message($mobile, $message);
        }
        
        if($sendPinMethod == 'print')
        {
            Session::flash('topup_id', $topup->id);
//            return response()->json(['response' => 'success', 'print' => 'yes', 'topup_id' => $topup->id]);
        }  else {
            Session::flash('flash_message', 'PIN Number Send!');

//            return response()->json(['response' => 'success']);
        }        
        return response()->json(['response' => 'success']);
    }
    
    public function receipt(Request $request)
    {
        $page = $request['page'];
        $where['id'] = $request['topup_id'];
        
        if(userGroup() == 'agent')
        {
            $where['user_id'] = userId();
        }
        
        $topup = Topup::where($where)->first();

        return view('transactions.receipt', compact('page', 'topup'));
    }
    
    public function getProducts($categoryId)
    {
        echo getProducts($categoryId);
    }
    
    public function getProductAmounts($productId)
    {
        $data = '';
        
        $where['id']     = $productId;
        $where['status'] = 1;
        
        $product = Product::where($where)->first();
        
        unset($where['id']);
        
        $where['product_id'] = $productId;
       
        if($product->count() > 0)
        {
            foreach ($product->amounts as $row):
                
                $amount = $row->amount;
                $agentPrice = $row->pivot->agent_price;
                
                $where['status'] = 1;
                $where['amount'] = $amount;
            
                $pinNumbers = PinNumber::select('amount')->where('expired_date', '>=', date('Y-m-d'))->where($where)->count();
                
                $data .= '<div class="col-xs-6 col-sm-2">
                            <div class="product-item">
                                <span class="ribbon-featured display-hide">
                                    <strong class="ribbon">Selected</strong>
                                </span>
                                <div class="amount"><h1>'.getGlobalValue('currency').$amount.'</h1></div>';
                                if($pinNumbers > 0)
                                {
                                    $data .= '<a href="javascript:;" id="'.$amount.'" class="select-option-link btn btn-select price" data-container="body" data-placement="bottom" data-original-title="Agent Price: '.getGlobalValue('currency').$agentPrice.'">Available in Stock</a>';
                                }else
                                {
                                    $data .='<button type="button" class="select-option-link btn btn-out" data-container="body" data-placement="bottom" data-original-title="Agent Price: '.getGlobalValue('currency').$agentPrice.'">Out of Stock</button>';
                                }
                                
                $data .=    '</div>
                        </div>';
            endforeach;                   
        }else
        {
            $data = '<p class="no-product">There is not amount exist against this product</p>';
        }

        $data .= Form::hidden('amount', null, ['id' => 'amount']);
        echo $data;
    }
    
    function getBalance()
    {
        echo getBalance();
    }  
    
    public function unlockingMobileCoverPage()
    {
        $title = 'e-Unlocking Mobiles';
        return view('transactions.unlocking_mobile_cover_page', compact('title'));
    }
    
    public function unlockingMobile(Request $request)
    {
        $title      = 'IMEI Order';
        $countryId  = $request['country_id'];
        $brandId    = $request['brand_id'];
        
        $where['status'] = 1;
        $where['type'] = 3;
        
        $categories = Category::where($where)->orderBy('sort_order', 'DESC')->get();
        $select = 'categories.name AS category_name, services.category_id, services.id, services.name AS service_name, services.price, services.delivery_time';
        
        if($brandId != '' && $countryId != '')
        {
            $services = Service::select(\DB::raw($select))->join('categories', function ($join)
            {
                $join->on('services.category_id', '=', 'categories.id')->where(array('type' => 3, 'categories.status' => 1));
            })->whereHas('brands', function($query) use($brandId) 
            {
                $query->whereIn('brand_id', $brandId);
            })->whereHas('countries', function($query) use($countryId) 
            {
                $query->whereIn('country_id', $countryId);
            })->where(function($query) use ($request) 
            {
                $this->unlockingMobileFilter($query, $request);
            })->orderBy('categories.sort_order', 'DESC')->orderBY('services.name')->get();
        }else if($brandId != '')
        {
            $services = Service::select(\DB::raw($select))->join('categories', function ($join) 
            {
                $join->on('services.category_id', '=', 'categories.id')->where(array('type' => 3, 'categories.status' => 1));
            })->whereHas('brands', function($query) use($brandId) 
            {
                $query->whereIn('brand_id', $brandId);
            })->where(function($query) use ($request) 
            {
                $this->unlockingMobileFilter($query, $request);
            })->orderBy('categories.sort_order', 'DESC')->orderBY('services.name')->get();
        }else if($countryId != '')
        {
            $services = Service::select(\DB::raw($select))->join('categories', function ($join) 
            {
                $join->on('services.category_id', '=', 'categories.id')->where(array('type' => 3, 'categories.status' => 1));
            })->whereHas('countries', function($query) use($countryId) 
            {
                $query->whereIn('country_id', $countryId);
            })->where(function($query) use ($request) 
            {
                $this->unlockingMobileFilter($query, $request);
            })->orderBy('categories.sort_order', 'DESC')->orderBY('services.name')->get();
        }else
        {
            $services = Service::select(\DB::raw($select))->join('categories', function ($join) 
            {
                $join->on('services.category_id', '=', 'categories.id')->where(array('type' => 3, 'categories.status' => 1));
            })->where(function($query) use ($request) 
            {
                $this->unlockingMobileFilter($query, $request);
            })->orderBy('categories.sort_order', 'DESC')->orderBY('services.name')->get(); 
        }

        return view('transactions.unlocking_mobile', compact('title', 'request', 'categories', 'services'));
    }
    
    private function unlockingMobileFilter($query, $request)
    {
        $query->where('services.status', 1);
        if($request['category_id'] != '')
        {
            $query->whereIn('category_id', $request['category_id']);
        }

        if($request['network_id'] != '')
        {
            $query->whereIn('network_id', $request['network_id']);
        }
    }
            
    public function unlockingMobileDetail(Request $request)
    {
        $title = 'Place IMEI Order';
        $where['id'] = $request['service_id'];
        
        $service = Service::where($where)->first();
        
        return view('transactions.unlocking_mobile_detail', compact('title', 'service'));
    }
    
    public function unlockingMobileStore(Request $request)
    {
        $this->validate($request, [
            'service_id'    => 'required',
            'price'         => 'required',
            'total_price'   => 'required|numeric|max:'.getClientLimit(),
            'imei_number.*' => 'required|digits:15',//|unique:unlocking_mobiles,imei_number,NULL,id,service_id,'.$request['service_id']
        ]);
        
        $duplicateImei = array();
        $imei = $request['imei_number'];
        $count = count($imei);
        
        for($i = 0; $i < $count; $i++)
        {
            $duplicate = UnlockingMobile::where('imei_number', $imei[$i])->whereIn('status', [0,3])->count();
            
            if($duplicate == 0)
            {
                $transactionId = getAgentTransactionId();

                $request['imei_number']    = $imei[$i];
                $request['transaction_id'] = $transactionId;        
                $request['user_id']        = userId();

                $requestData = $request->all();

                $unlockingMobile = UnlockingMobile::create($requestData);

                $price = $request['price'];

                $previousBalance = getBalance();
                $currentBalance  = $previousBalance - $price;

                $action = 'Unlocking Mobile (Order No: '.$transactionId.')';

                $this->deductBalance($price, $action);

                $subject = 'New Order(s) Notification';

                $this->sendUnlockingMobileEmail($unlockingMobile, $subject, $previousBalance, $currentBalance);
            }else
            {
                $duplicateImei[] = $imei[$i];
            }
        }
        
        if($count == count($duplicateImei))
        {
            $message =  'IMEI(s) Already exist!';
            return response()->json(['message' => $message]);
        }else
        {    
            $message = 'Your order has been placed';

            if(count($duplicateImei) > 0)
            {
                $message .= ' and these IMEI(s) Aleardy exist '.join(', ', $duplicateImei);
            }
        
            Session::flash('flash_message', $message.'!');
        
            return response()->json(['response' => 'success']);
        }
    }
    
    public function cancelUnlockingMobileOrder(Request $request)
    {
        $where['id']      = $request['id'];
        $where['user_id'] = userId();
        $where['status']  = 0;
        
        $result = UnlockingMobile::where($where)->update(array('status' => 4));// 0 => Pending, 1 => Completed, 2 => Reject, 3 => In Process, 4 => Cancel
        
        if($result > 0)
        { 
            unset($where['status']);
            $unlockingMobile = UnlockingMobile::where($where)->first();
        
            $amount = $unlockingMobile->price;
            $transactionId = $unlockingMobile->transaction_id;
            
            $action = 'Refund Unlocking Mobile due to cancel order (Order No: '.$transactionId.')';
            
            $this->addBalance($amount, $action);

            $previousBalance = getBalance();
            $currentBalance  = $previousBalance + $amount;

            $subject = 'Response for your order: '.$transactionId.' Order Cancelled';

            $this->sendUnlockingMobileEmail($unlockingMobile, $subject, $previousBalance, $currentBalance);
        
            Session::flash('flash_message', 'You order has been cancelled and amount refund in your balance!');
            return response()->json(['response' => 'success']);
        }else
        {
            return response()->json(['message' => 'Your order can not be cancelled because it is in process state!']);
        }
    }
    
    private function sendUnlockingMobileEmail($unlockingMobile, $subject, $previousBalance, $currentBalance)
    {
        $mailer = \App::make('jmailer');

        $viewFile = 'mail.unlocking_mobile';

        $userName = getUserName($unlockingMobile);
        $companyLogo = ($unlockingMobile->userProfile->company_logo != '')?'images/company_profiles/'.$unlockingMobile->userProfile->company_logo:'packages/mnr_ehub/img/print_logo.png';
        $header = ($unlockingMobile->userProfile->header != '')?$unlockingMobile->userProfile->header:'';
        
        $body['user_name']        = $userName;
        $body['company_logo']     = $companyLogo;
        $body['header']           = $header;
        $body['email']            = getEmail();
        $body['imei']             = $unlockingMobile->imei_number;
        $body['order_no']         = $unlockingMobile->transaction_id;
        $body['order_date']       = $unlockingMobile->created_at;
        $body['previous_balance'] = $previousBalance;
        $body['current_balance']  = $currentBalance;
        $body['service']          = $unlockingMobile->service->name;
        $body['amount']           = $unlockingMobile->price;
        $body['status']           = $unlockingMobile->status;
        
        // send email to client
        $mailer->sendTo(getEmail(), $body, $subject, $viewFile);
        
        // send email to Admin
        $mailer->sendTo(getGlobalValue('superadmin_email'), $body, $subject, $viewFile);
    }
    
    private function sendBankingEmail($banking)
    {
        $mailer = \App::make('jmailer');

        $viewFile = 'mail.banking';

        $userName = getUserName($banking);
        
        $body['user_name']      = $userName;
        $body['transaction_id'] = $banking->transaction_id;
        $body['date']           = $banking->date;
        $body['bank']           = $banking->bank->name;
        $body['payment_ref']    = $banking->payment_ref;
        $body['amount']         = $banking->amount;
        
        // send email to client
        $mailer->sendTo(getEmail(), $body, 'e-Banking', $viewFile);
        
        // send email to Admin
        $mailer->sendTo(getGlobalValue('superadmin_email'), $body, 'e-Banking', $viewFile);
    }
    
    private function addBalance($amount, $action)
    {
        $data['amount']  = $amount;
        $data['action']  = $action;
        $data['user_id'] = userId();

        UserBalance::create($data);

        $where['id'] = userId();

        DB::table('users')->where($where)->increment('balance', $amount);
    }
    
    private function deductBalance($amount, $action)
    {
        $data['amount']  = $amount;
        $data['action']  = $action;
        $data['user_id'] = userId();

        UserBalance::create($data);

        $where['id'] = userId();

        DB::table('users')->where($where)->decrement('balance', $amount);
    }
    
    /*    
    public function instantCreditStore(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|min:100',
        ]);
        
        $amount = $request['amount'];
        $pament_method = $request['payment_method'];
        
        if($pament_method == 'stripe')
        {
            return view('transactions.stripe', compact('amount'));
        }else if($pament_method == 'paypal')
        {
            return view('transactions.paypal', compact('amount'));
        }
    }
    
    public function stripeStore(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|min:100',
        ]);

        try 
        {
            Stripe::setApiKey(env('STRIPE_SECRET'));
            $result = Stripe::charges()->create(
                array(
                    "amount"      => $request['amount'],
                    "currency"    => "gbp",
                    "card"        => $request['stripeToken'],
                    "description" => 'Transaction (£'.$request['amount'].'.00)'
                )
            );

            if($result['paid'] == 1)
            {
                $userId = userId();
                $amount = $result['amount'] / 100;

                $data['amount']  = $amount;
                $data['action']  = 'Payment By Stripe';
                $data['user_id'] = $userId;

                UserBalance::create($data);

                $where['id'] = $userId;

                DB::table('users')->where($where)->increment('balance', $amount);
            }
            
            $response = json_encode($result);
            
        } catch(Cartalyst\Stripe\Exception\BadRequestException $e) 
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        } catch (Cartalyst\Stripe\Exception\UnauthorizedException $e)
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        } catch (Cartalyst\Stripe\Exception\InvalidRequestException $e)
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        } catch (Cartalyst\Stripe\Exception\NotFoundException $e)
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        } catch (Cartalyst\Stripe\Exception\CardErrorException $e)
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        } catch (Cartalyst\Stripe\Exception\ServerErrorException $e)
        {
            $code    = $e->getCode();
            $message = $e->getMessage();
            $type    = $e->getErrorType();

            $response = 'Error Code: '.$code.' Error Message: '.$message.' Error Type: '.$type;
        }

        $data_1['response'] = $response;
        $data_1['payment_method'] = 'Stripe';
        $data_1['user_id'] = $userId;

        PaymentMethodResponse::create($data_1);    
 
        if($result['paid'])
        {
            Session::flash('payment_success', 'Payment Successful!');
        }else
        {
            Session::flash('payment_fail', 'Payment Failed!');
        }
        return redirect('/');
    }
    
    public function paypalStore(Request $request)
    {
        $userId = $request['item_number'];

        $data_1['response'] = $request;
        $data_1['payment_method'] = 'Paypal';
        $data_1['user_id'] = $userId;

        PaymentMethodResponse::create($data_1);
        
        if($request['payment_status'] == 'Completed')
        {
            $amount = $request['payment_gross'];
            
            $data['amount']  = $amount;
            $data['action']  = 'Payment By Paypal';
            $data['user_id'] = $userId;

            UserBalance::create($data);

            $where['id'] = $userId;

            DB::table('users')->where($where)->increment('balance', $amount);
        }
    }    
    
    public function paypalThanks(Request $request)
    {
        if($request['payment_status'] == 'Completed')
        {
            Session::flash('payment_success', 'Payment Successful!');
        }else
        {
            Session::flash('payment_fail', 'Payment Failed!');
        }
        return redirect('/');
    }
    
    public function paypalcancel(Request $request)
    {
        Session::flash('payment_fail', 'Payment Cancel');
        return redirect('/');
    }*/
}
