<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\App;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $customUrl = '/')
    {
        if (App::make('authenticator')->check()) {
            return redirect($customUrl);
        }

        return $next($request);
    }
}
