<?php
use Carbon\Carbon;
use App\Classes\USmartApiClass;

/***************************Get Agent Transaction Id***************************/

function getAgentTransactionId()
{
    $where['config_key'] = 'agent_transaction_id';
    DB::table('configs')->where($where)->increment('config_value', 1);
    
    $config = App\Config::where($where)->first();
    
    return $config->config_value;
}


/***************************Get Allow Duplicate IMEI***************************/

function getAllowDuplicateImei()
{
    return Form::select('allow_duplicate_imei', [
                0 => 'No',
                1 => 'Yes'
            ], null, [ 
                'class' => 'form-control select2'
        ]);
}

/**********************************Get Amount**********************************/

function getAmount($amount = null)
{
    return Form::select('amount[]',
            ['' => 'Select Card Price'] +
            App\Amount::pluck('amount', 'id')->all(),
            $amount, [ 
            'class' => 'form-control select2'
        ]);
}

/*******************************Get Amount Type********************************/

function getAmountType()
{
    return Form::select('amount_type', [
                'fixed'   => getGlobalValue('currency'),
                'percent' => '%'
            ], null, [ 
                'class' => 'form-control select2'
        ]);
}

/***********************************Get APIs***********************************/

function getApis()
{
    return Form::select('api_id',
            ['' => 'Select API'] +
                    App\Api::pluck('user_name', 'id')->all(),
            null, [ 
            'id' => 'api_id', 'class' => 'form-control select2'
        ]);
}

/******************************Get API Categories******************************/

function getApiCategories($apiId, $id = null)
{
    $data = array();
    $response = array();

    $api = \App\Api::where('id', $apiId)->first();

    if($api->count() > 0)
    {
        $uSmartApiClass = new USmartApiClass($api->api, $api->user_name, $api->url);
        $uSmartApiClass->doAction('imeiservices', array());

        $result = $uSmartApiClass->getResult();
        $uSmartApiClass->XmlToArray($result);
        $arrayData = $uSmartApiClass->createArray();

        if(isset($arrayData['error']) && sizeof($arrayData['error']) > 0)
        {
            $data[0] = $arrayData['error'][0];
        }else
        {
            if(isset($arrayData['Packages']['Package']) && sizeof($arrayData['Packages']['Package']) > 0)
            {
                $response = $arrayData['Packages']['Package'];
            }

            $total = count($response);
            for($count = 0; $count < $total; $count++)
            {
                $data[$response[$count]['Category']] = $response[$count]['Category'];		
            }
        }
    }

    return Form::select('category_id', 
        ['' => ''] +
        $data,
        $id, [ 
        'data-placeholder' => 'Select Category', 'id' => 'category_id', 'class' => 'form-control select2'
    ]);
}

/*******************************Get API Services*******************************/

function getApiServices($apiId, $id = null, $categoryId = '')
{
    $data = array();
    $response = array();

    $api = \App\Api::where('id', $apiId)->first();

    if($api->count() > 0)
    {
        if($categoryId != '')
        {
            $services = App\Service::where('api_id', $api->id)->pluck('api_service_id')->toArray();
        }
        
        $uSmartApiClass = new USmartApiClass($api->api, $api->user_name, $api->url);
        $uSmartApiClass->doAction('imeiservices', array());

        $result = $uSmartApiClass->getResult();
        $uSmartApiClass->XmlToArray($result);
        $arrayData = $uSmartApiClass->createArray();

        if(isset($arrayData['error']) && sizeof($arrayData['error']) > 0)
        {
            $data[0] = $arrayData['error'][0];
        }else
        {
            if(isset($arrayData['Packages']['Package']) && sizeof($arrayData['Packages']['Package']) > 0)
            {
                $response = $arrayData['Packages']['Package'];
            }

            $total = count($response);
            for($count = 0; $count < $total; $count++)
            {
                if($categoryId != '')
                {
                    $name = 'api_service_id[]';
                    if(trim($categoryId) == trim($response[$count]['Category']))
                    {
                        if(!in_array($response[$count]['PackageId'], $services))
                        {
                            $data[$response[$count]['PackageId']] = $response[$count]['Category'].' - '.$response[$count]['PackageTitle'].' - '.$response[$count]['PackagePrice'].' Credit '.$response[$count]['TimeTaken'].' Business Day';	
                        } 
                    }
                }else
                {
                    $name = 'api_service_id';
                    $data[$response[$count]['PackageId']] = $response[$count]['Category'].' - '.$response[$count]['PackageTitle'].' - '.$response[$count]['PackagePrice'].' Credit '.$response[$count]['TimeTaken'].' Business Day';
                }
            }
        }
    }

    return Form::select($name, 
        $data,
        $id, [ 
        'data-placeholder' => 'Select API Service', 'id' => 'api_service_id', 'class' => 'form-control select2'
    ]);
}

/*********************************Get Balance**********************************/

function getBalance()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser();
    return $loggedUser->balance;
}

/**********************************Get Banks***********************************/

function getBanks($bankId = null)
{
    $where['status'] = 1;
    
    return Form::select('bank_id', 
            ['' => 'Select Bank'] +
            App\Bank::where($where)->pluck('name', 'id')->all(),
            $bankId, [ 
            'id' => 'bank_id', 'class' => 'form-control select2'
        ]);
}

/**********************************Get Brands**********************************/

function getBrands($brandId = null)
{
    $where['status']  = 1;
    
    return Form::select('brand_id', 
            ['' => 'Select Brand'] +
            App\Brand::where($where)->pluck('name', 'id')->all(),
            $brandId, [ 
            'id' => 'brand_id', 'class' => 'form-control select2'
        ]);
}

function getMultipleBrands($id = null)
{
    $where['status']  = 1;
    
    return Form::select('brand_id[]',
            App\Brand::where($where)->pluck('name', 'id')->all(),
            $id, [ 
            'data-placeholder' => 'All', 'id' => 'brand_id', 'class' => 'form-control select2', 'multiple' => ''
        ]);
}

/********************************Get Card Type*********************************/

function getCardType()
{
    return Form::select('brand', [
                'visa'             => 'Visa',
                'mastercard'       => 'Mastercard',
                'american_express' => 'American Express',
                'discover'         => 'Discover',
                'diners_club'      => 'Diners Club',
                'jcb'              => 'JCB'
            ], null, [ 
                'class' => 'form-control select2'
        ]);
}

/******************************Get Cargo Services******************************/

function getCargoServices($cargoType)
{       
    $where['cargo_type'] = $cargoType;
    $where['status'] = 1;
    
    return Form::select('cargo_service_id', 
            ['' => 'Select Cargo Service'] +
            App\CargoService::where($where)->pluck('name', 'id')->all(),
            null, [ 
            'class' => 'form-control select2'
        ]);
}

function getCargoServices2($cargoType, $collectionCountryId, $deliveryCountryId)
{   
    $data = array();
    $where['cargo_type'] = $cargoType;
    $where['collection_country_id'] = $collectionCountryId;
    $where['delivery_country_id'] = $deliveryCountryId;
    
    $cargoServiceRates = App\CargoServiceRate::where($where)->get();
    
    if($cargoServiceRates->count() > 0)
    {
        foreach($cargoServiceRates as $row)
        {
            $data[$row->cargo_service_id] = $row->cargoService->name;
        }
    }
    
    return Form::select('cargo_service_id', 
            ['' => 'Select Cargo Service'] +
            $data,
            null, [ 
            'id' => 'cargo_service_id', 'class' => 'form-control select2'
        ]);
}

/********************************Get Categories********************************/

function getCategories($type, $id = null)
{    
    $where['type']   = $type;
    $where['status'] = 1;
    
    return Form::select('category_id', 
            ['' => ''] +
            App\Category::where($where)->pluck('name', 'id')->all(),
            $id, [ 
            'data-placeholder' => 'Select Category', 'id' => 'category_id', 'class' => 'form-control select2'
        ]);
}

function getCategoriesAdmin($id = null)
{
    $where['status']  = 1;
    
    return Form::select('category_id', 
            ['' => 'Select Category'] +
            App\Category::where($where)->whereIn('type', [1, 2])->pluck('name', 'id')->all(),
            $id, [ 
                'id' => 'category_id', 'class' => 'form-control select2'
        ]);
}
/*
function getCategoriesNetwork()
{
    $where['category_id']  = 4;

    return Form::select('network_id',
        ['' => 'Select Network'] +
        App\Product::where($where)->pluck('name', 'id')->all(),
        null, [
            'id' => 'network_id', 'class' => 'form-control select2'
        ]);
}*/
//AM (Get Multiple product information according Network)
function getSimMonthList($monthYear)
{
    $products = App\SimInformationData::whereNotNull('user_id')->groupBy(\DB::raw('EXTRACT(MONTH FROM created_at)'))->get();

    foreach($products as $row)
    {
        $created_date = new Carbon ($row->created_at);
        $years = $created_date->format('Y');
        $y = $created_date->format('Y');
        $months = $created_date->format('F');
        $m = $created_date->format('m');
        $data[$m.'|'.$y] = $months.' '.$years;
    }

    return  Form::select('month_year',
        $data
        ,$monthYear, [
            'id'=> 'month_year', 'class' => 'form-control select2'
        ]);
}
//AM (Get Multiple product information according Network)
function getSimProducts($networkId)
{
    $where['network_id'] = $networkId;

    return Form::select('product_id',
        ['' => 'Select Product'] +
        App\SimProduct::where($where)->pluck('name', 'id')->all(),
        null, [
            'id' => 'product_id', 'class' => 'form-control select2'
        ]);
}
//AM (Get Multiple product information according DB Value)
/*function getCliProductInfo($cli)
{

    return $cli_verifiy = App\SimInformationData::where('allotted_user_id',NULL)
                        ->where(function($query) use ($cli){
                            return $query
                                ->where('cli', $cli)
                                ->orWhere('ssn', $cli);
    })->count();

    //dd($cli_verifiy);
}
//AM (Add multiple filed on SSN and CLI add )
/*
function getSsnCli($name, $amount = array()){

    if($name == 'amount')
    {
        $title = 'Cart Price';
    }else if($name == 'agent_price')
    {
        $title = 'Agent Price';
    }else if($name == 'cost_price')
    {
        $title = 'Cost Price';
    }

    return Form::select($name.'[]',
        ['' => $title] +
        App\Amount::pluck('amount', 'id')->all(),
        $amount, [
            'class' => 'form-control select2'
        ]);
}*/
function getMultipleCategories($type, $id = null)
{    
    $where['type']   = $type;
    $where['status'] = 1;
    
    return Form::select('category_id[]', 
            App\Category::where($where)->pluck('name', 'id')->all(),
            $id, [ 
                'id' => 'category_id', 'class' => 'form-control select', 'multiple' => ''
        ]);
}

/*******************************Get Client Limit*******************************/

function getClientLimit()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser(); 
    $profile = $loggedUser->user_profile()->first();
    return $profile->credit_limit + getBalance();
}

/*****************************Get Company Profile******************************/

function getCompanyProfile()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser(); 
    $profile = $loggedUser->user_profile()->first();
    
    $data['company_logo'] = ($profile->company_logo != '')?'images/company_profiles/'.$profile->company_logo:'packages/mnr_ehub/img/print_logo.png';
    $data['header'] = ($profile->header != '')?$profile->header:'';
    $data['description'] = ($profile->description != '')?$profile->description:'';
    $data['footer'] = ($profile->footer != '')?$profile->footer:'';
    
    return $data;
}

function getGlobalValue($configKey)
{
    $config = App\Config::where(array('config_key' => $configKey))->firstOrFail();
    return $config->config_value;
}

/********************************Get Countries*********************************/

function getCountries($name, $id = 230)
{
    return Form::select($name, 
            ['' => 'Select Country'] +
            App\Country::pluck('name', 'id')->all(),
            $id, [ 
            'data-placeholder' => 'Select Country', 'id' => 'country_id', 'class' => 'form-control select2'
        ]);
}

function getCountriesName()
{
    return Form::select('address_country', 
            ['' => 'Select Country'] +
            App\Country::pluck('name', 'name')->all(),
            null, [ 
                'class' => 'form-control select2'
        ]);
}

function getMultipleCountries($id = null)
{
    return Form::select('country_id[]', 
            App\Country::pluck('name', 'id')->all(),
            $id, [ 
            'data-placeholder' => 'All', 'id' => 'country_id', 'class' => 'form-control select2', 'multiple' => ''
        ]);
}
/*
function getCountriesCode($name, $id = null)
{
   return Form::select($name, 
            ['' => 'Select Country'] +
            App\Country::pluck('name', 'sortname')->all(),
            $id, [ 
                'class' => 'form-control select2'
        ]);
}
*/
/****************************Get Custom Field Types****************************/

function getCustomFieldTypes()
{
    return Form::select('field_type_id', 
            ['' => 'Select Custom Field'] +
            App\CustomFieldType::pluck('name', 'id')->all(),
            null, [ 
            'id' => 'field_type_id', 'class' => 'form-control select2'
        ]);
}

/****************************Get Custom Field Values****************************/

function getCustomFieldValues()
{
    return Form::select('field_values', 
            [
                'add' => 'Add',
                'deduct' => 'Deduct'
            ],
            null, [ 
            'class' => 'form-control select2'
        ]);
}

/****************************Get Delivery Countries****************************/

function getDeliveryCountries($cargoType, $countryId)
{   
    $data = array();
    $where['cargo_type'] = $cargoType;
    $where['collection_country_id'] = $countryId;
    
    $deliveryCountries = App\CargoServiceRate::where($where)->get();
    
    if($deliveryCountries->count() > 0)
    {
        foreach($deliveryCountries as $row)
        {
            $data[$row->delivery_country_id] = $row->deliveryCountry->name;
        }
    }
    
    return Form::select('delivery_country_id', 
            ['' => ''] +
            $data,
            null, [ 
            'id' => 'delivery_country_id', 'class' => 'form-control select2'
        ]);
}

/***********************************Get Date***********************************/

function getDate2($date)
{
    return Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
}

function getDateTime($date)
{
    return Carbon::createFromFormat('d/m/Y H:i:s', $date)->format('Y-m-d H:i:s');
}

function getDateFrom($date)
{
    return Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d 00:00:00');
}

function getDateTo($date)
{
    return Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d 23:59:59');
}

function getDateUk($date)
{
    return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('d/m/Y H:i:s');
}

function getDateUk2($date)
{
    if($date != '')
    {
        return Carbon::createFromFormat('Y-m-d', $date)->format('d/m/Y');
    }  else {
        return '';
    }
}

/*********************************Get Email**********************************/

function getEmail()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser();
    return $loggedUser->email;
}

/*******************************IMEI Field Type********************************/

function getImeiFieldType()
{
    return Form::select('imei_field_type', [
                1 => 'Single',
                2 => 'Multiple',
                3 => 'Remove IMEI Option',
            ], null, [ 
                'class' => 'form-control select2'
        ]);
}

/**********************************Get Models**********************************/

function getModels($brandId, $modelId = null)
{
    $where['brand_id'] = $brandId;
    $where['status']   = 1;
    
    return Form::select('model_id', 
            ['' => 'Select Model'] +
            App\MobileProduct::where($where)->pluck('name', 'id')->all(),
            $modelId, [ 
            'id' => 'model_id', 'class' => 'form-control select2'
        ]);
}

/*********************************Get Modules**********************************/

function getModules()
{
    $where['user_id'] = userId();
    
    return Form::select('module_id', 
            ['' => 'Select Module'] +
            App\Module::where($where)->orWhere('global', 1)->pluck('name', 'id')->all(),
            null, [ 
            'id' => 'module_id', 'class' => 'form-control select2'
        ]);
}

/*********************************Get Networks*********************************/

function getNetworks()
{
//    $where['status'] = 1;
    
    return Form::select('network_id', 
            ['' => 'Select Network'] +
            App\Network::pluck('name', 'id')->all(),
            null, [ 
            'id' => 'network_id', 'class' => 'form-control select2'
        ]);
}

function getMultipleNetworks($id = null)
{
    $where['status'] = 1;
    
    return Form::select('network_id[]', 
            App\Network::where($where)->pluck('name', 'id')->all(),
            $id, [ 
                'class' => 'form-control select', 'multiple' => ''
        ]);
}

/*********************************Get Networks*********************************/

function getNetworkCommission()
{
    $where['status'] = 1;
    
    return Form::select('network_commission_id', 
            ['' => 'Select Network Commission'] +
                App\NetworkCommission::where($where)->pluck('name', 'id')->all(),
            null, [ 
                'class' => 'form-control select2'
        ]);
}

/*********************************Get Oprions**********************************/

function getOptions()
{
    return Form::select('after_amount', [
                0 => 'No',
                1 => 'Yes'
            ], null, [ 
                'class' => 'form-control select2'
        ]);
}

/**************************Get Ordinal Number Suffix***************************/

function getOrdinalNumberSuffix($num) 
{
    if (!in_array(($num % 100),array(11,12,13)))
    {
        switch ($num % 10) 
        {
            // Handle 1st, 2nd, 3rd
            case 1:  return $num.'st';
            case 2:  return $num.'nd';
            case 3:  return $num.'rd';
        }
    }
    return $num.'th';
}

/*********************************Get Products*********************************/

function getProducts($categoryId = '', $id = null, $filter = 1)
{
    if($categoryId == 1)
    {
        $name = 'Select Operator';
    }else if($categoryId == 4)
    {
        $name = 'Select Network';
    }else
    {
        $name = 'Select Product';
    }
    
    return Form::select('product_id', 
            ['' => ''] +
            App\Product::where(function ($query) use($categoryId, $filter)
            {
                if($categoryId != '')
                {
                    $query->where('category_id', $categoryId);
                }

                if($filter == 1)
                {
                    $query->where('status', 1);
                }
                
            })->pluck('name', 'id')->all(),
            $id, [ 
            'data-placeholder' => 'Select Product', 'id' => 'product_id', 'class' => 'form-control select2'
        ]);
}
/*
function getProductsAdmin()
{
    $where['status'] = 1;

    return Form::select('product_id', 
            ['' => 'Select Product'] +
            App\Product::where($where)->pluck('name', 'id')->all(),
            null, [ 
                'id' => 'product_id', 'class' => 'form-control select2'
        ]);
}
*/
/******************************Get Product Amount******************************/

function getProductAmount($productId)
{
    $amounts = array();
    
    $where['id'] = $productId;
    $where['status'] = 1;
    $product = App\Product::where($where)->first();
    
    if($product->count() > 0)
    {
        foreach ($product->amounts as $amount):
            $amounts[$amount->amount] = $amount->amount;
        endforeach;
    }
    
    return Form::select('amount', 
        ['' => 'Select Amount'] +
        $amounts, null, [ 
        'id' => 'amount', 'class' => 'form-control select2'
    ]);
}

/*********************************Get Profile**********************************/

function getProfile()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser(); 
    $profile = $loggedUser->user_profile()->first();
    return $profile;
}

/*********************************Get Services*********************************/
/*
function getServices()
{    
//    $where['type']   = $type;
    $where['status'] = 1;
    
    return Form::select('service_id', 
            ['' => 'Select Service'] +
            App\Service::where($where)->pluck('name', 'id')->all(),
            null, [ 
                'id' => 'service_id', 'class' => 'form-control select2'
        ]);
}
*/
/**********************************Get Status**********************************/

function getStatus($status = null)
{
    return Form::select('status', [
                '' => 'Select Status',
                1  => 'Enabled',
                0  => 'Disabled',
                2  => 'Used'
            ], $status, [ 
                'class' => 'form-control select2'
        ]);
}

function getStatus2($status = null)
{
    return Form::select('status', [
                '' => 'Select Status',
                1  => 'Enabled',
                0  => 'Disabled'
            ], $status, [ 
                'class' => 'form-control select2'
        ]);
}

/******************************Get Transaction Id******************************/

function getTransactionId()
{
    $where['user_id'] = userId();
    DB::table('user_profile')->where($where)->increment('customer_transaction_id', 1);
    
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser(); 
    $profile = $loggedUser->user_profile()->first();
    
    return $profile->customer_transaction_id;
}

/*************************Get Unlocking Mobile Status**************************/

function getUnlockingMobileStatus($status)
{
    if($status == 'Pending')
    {
        $result = 0;
    }else if($status == 'Completed')
    {
        $result = 1;
    }else if($status == 'Rejected')
    {
        $result = 2;
    }else if($status == 'In Process')
    {
        $result = 3;
    }
    
    return $result;
}

function getUserName($row)
{
    $firstName = $row->userProfile->first_name;
    $LastName = $row->userProfile->last_name;
    
    return ($firstName != '' || $LastName != '')?$firstName.' '.$LastName:'User';
}

/**********************************Set Status**********************************/

function setStatusHTML($id, $status)
{
    $html = '';
    
    if($status == 1)
    {
        $html = '<button type="button" class="btn btn-success btn-sm" id="'.$status.'">Enabled</button>';
    }else if($status == 0)
    {
        $html = '<button type="button" class="btn btn-danger btn-sm" id="'.$status.'">Disabled</button>';
    }    
    
    return '<a href="javascript:;" id="'.$id.'" class="update_status">'.$html.'</a>';
}

/********************************Get User Group********************************/

function userGroup()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser();
    $group = $loggedUser->getGroups()->first();
    return $group->name;
}

/*********************************Get User ID**********************************/

function userId()
{
    $auth = \App::make('authenticator');
    $loggedUser = $auth->getLoggedUser();
    return $loggedUser->id;
}
