<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class MobileOrder extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'mobile_orders';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['brand_id', 'model_id', 'product_type', 'quantity', 'price', 'total', 'delivered', 'transaction_id', 'user_id'];
    
    public function brand()
    {
        return $this->belongsTo('App\Brand');
    }
    
    public function model()
    {
        return $this->belongsTo('App\MobileProduct');
    }

    public function userProfile()
    {
        return $this->belongsTo('LaravelAcl\Authentication\Models\UserProfile', 'user_id');
    }
    
    function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('d/m/Y H:i:s');
    }
}
