<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class NetworkCommissionScheme extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'network_commission_scheme';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['network_id', 'network_commission_id', 'topup_level', 'commission', 'sort_order', 'user_id'];

    public function network()
    {
        return $this->belongsTo('App\Network');
    }
}
