<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Yadakhov\InsertOnDuplicateKey;
use DB;

class NetworkIncentive extends Model
{
    use InsertOnDuplicateKey;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'network_incentive';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'product_date',
        'product',
        'sim_number',
        'topup_level',
        'topup_face_value',
        'product_incentive',
        'incentive',
        'suspected_deduction',
        'boundle_incentives',
        'paid',
        'user_id'
    ];

    public function simInformationData()
    {
        return $this->belongsTo('App\SimInformationData', 'sim_number', 'ssn');
    }
    
    public function scopeUpdateNetworkIncentive($query, $dateFrom = '', $dateTo = '')
    {
        DB::beginTransaction();
        
        $sql = "UPDATE network_incentive n 
                    INNER JOIN sim_information_data s ON s.ssn = n.sim_number
                    INNER JOIN user_profile u ON s.agent_id = u.user_id 
                    INNER JOIN network_commission_scheme nc ON u.network_commission_id = nc.network_commission_id 
                        SET n.incentive = nc.commission, n.status = 1 
                            WHERE n.topup_level = CONCAT('Topup ', nc.topup_level) AND n.status = 0";
                            
                            if($dateFrom != '' && $dateTo != '')
                            {
                                $sql .= " And n.created_at BETWEEN '".$dateFrom."' AND '".$dateTo."'";
                            }
        DB::update($sql);

        DB::commit();
    }
}
