<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class PinNumber extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'pin_numbers';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['pin_number', 'serial_number', 'product_id', 'amount', 'sale_price', 'expired_date', 'status', 'user_id'];

    public function product()
    {
        return $this->belongsTo('App\Product');
    }
    
    function setExpiredDateAttribute($date)
    {
        return $this->attributes['expired_date'] = Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
    }
    
    function getExpiredDateAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d', $date)->format('d/m/Y');
    }
}
