<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ReferralUser extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'referral_users';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'phone_no',
        'mobile_no',
        'service_id',
        'requirements',
        'status',
        'transaction_id',
        'user_id'
    ];
    
    public function userProfile()
    {
        return $this->belongsTo('LaravelAcl\Authentication\Models\UserProfile', 'user_id');
    }
    
    public function service()
    {
        return $this->belongsTo('App\MnrService');
    }
}
