<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'services';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'category_id',
        'network_id',
        'price',
        'cost_price',
        'delivery_time',
        'imei_field_type',
        'image_name',
        'terms',
        'allow_duplicate_imei',
        'api_id',
        'api_service_id',
        'sort_order',
        'status',
        'user_id'
    ];

    public function setApiIdAttribute($apiId)
    {
        $this->attributes['api_id'] = ($apiId !== '') ? $apiId : null;
    }
    
    public function setApiServiceIdAttribute($apiServiceId)
    {
        $this->attributes['api_service_id'] = ($apiServiceId !== '') ? $apiServiceId : null;
    }
    
    public function api()
    {
        return $this->belongsTo('App\Api');
    }
    
    public function brands()
    {
        return $this->belongsToMany('App\Brand');
    }
    
    public function category()
    {
        return $this->belongsTo('App\Category');
    }
    
    public function countries()
    {
        return $this->belongsToMany('App\Country');
    }
    
    public function network()
    {
        return $this->belongsTo('App\Network');
    }
    
    public function setNetworkIdAttribute($networkId)
    {
        $this->attributes['network_id'] = ($networkId !== '') ? $networkId : null;
    }
}
