<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SimInformation extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'sim_informations';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['network_id', 'product_id', 'user_id'];

    public function simInformationData()
    {
        return $this->hasMany('App\SimInformationData');
    }

    public function network()
    {
        return $this->belongsTo('App\Network');
    }
    public function product()
    {
        return $this->belongsTo('App\SimProduct');
    }
}
