<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SimProduct extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'sim_products';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['name', 'network_id', 'user_id'];

    public function network()
    {
        return $this->belongsTo('App\Network');
    }    
}
