<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Topup extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'topup';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['category_id', 'pin_number_id', 'amount', 'contact_info', 'send_pin_method', 'transaction_id', 'agent_transaction_id', 'user_id'];

    public function pinNumber()
    {
        return $this->belongsTo('App\PinNumber');
    }
        
    public function category()
    {
        return $this->belongsTo('App\Category');
    }
    
    public function userProfile()
    {
        return $this->belongsTo('LaravelAcl\Authentication\Models\UserProfile', 'user_id');
    }
    
    function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('d/m/Y H:i:s');
    }
}
