<?php

namespace App;

use LaravelAcl\Authentication\Models\UserProfile as SentryUserProfile;
use Carbon\Carbon;

class UserProfile extends SentryUserProfile
{
    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'title',
        'first_name',
        'last_name',
        'dob',
        'mobile_no',
        'business_no',
        'company',
        'vat',
        'network_commission_id',
        'credit_limit',
        'town',
        'county',
        'zip',
        'address',
        'company_logo',
        'description',
        'header',
        'footer',
        'customer_transaction_id'
    ];
    
    public function setNetworkCommissionIdAttribute($networkCommissionId)
    {
        $this->attributes['network_commission_id'] = ($networkCommissionId != '') ? $networkCommissionId : null;
    }
    
    public function setBusinessNoAttribute($businessNo)
    {
        $this->attributes['business_no'] = ($businessNo !== '') ? $businessNo : null;
    }
    
    public function setTownAttribute($town)
    {
        $this->attributes['town'] = ($town !== '') ? $town : null;
    }
    
    public function setCountyAttribute($county)
    {
        $this->attributes['county'] = ($county !== '') ? $county : null;
    }
    
    public function setZipAttribute($zip)
    {
        $this->attributes['zip'] = ($zip !== '') ? $zip : null;
    }
    
    function setDobAttribute($date)
    {
        return $this->attributes['dob'] = ($date != '') ? Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d') : null;
    }
    
    function getDobAttribute($date)
    {
        if($date != '')
        {
            return Carbon::createFromFormat('Y-m-d', $date)->format('d/m/Y');
        }
    }
}
