<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserProfileTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
            Schema::dropIfExists('user_profile');
            Schema::create('user_profile', function(Blueprint $table)
            {
                $table->increments('id');
                $table->integer('user_id')->unsigned();
                $table->string('code', 25)->nullable();
                $table->string('title', 5)->nullable();
                $table->string('first_name', 50)->nullable();
                $table->string('last_name', 50)->nullable();
                $table->date('dob')->nullable();
                $table->string('mobile_no', 20)->nullable();
                $table->string('business_no', 20)->nullable();
                $table->string('company', 50)->nullable();
                $table->string('vat', 20)->nullable();
                $table->integer('network_commission_id')->unsigned()->nullable();
                $table->tinyInteger('page_refresh_time')->unsigned()->default(0);
                $table->decimal('credit_limit', 10, 2)->default(0.00);
                $table->string('town', 50)->nullable();
                $table->string('county', 50)->nullable();
                $table->string('zip', 20)->nullable();
                $table->string('address')->nullable();
                $table->binary('avatar')->nullable();
                $table->string('company_logo', 100)->nullable();            
                $table->text('description')->nullable();
                $table->text('header')->nullable();
                $table->text('footer')->nullable();
                $table->integer('customer_transaction_id')->unsigned()->default(0);
                $table->timestamps();

                // foreign keys
                $table->foreign('network_commission_id')
                    ->references('id')->on('network_commission')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');

                $table->foreign('user_id')
                    ->references('id')->on('users')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');
            });
        }

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::dropIfExists('user_profile');
    }

}
