<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function(Blueprint $table) {
            $table->increments('id');
            $table->string('name', 255);
            $table->integer('category_id')->unsigned();
            $table->integer('network_id')->unsigned()->nullable();
            $table->decimal('price', 10, 2);
            $table->decimal('cost_price', 10, 2)->default(0.00);
            $table->string('delivery_time', 30);
            $table->integer('process_after')->unsigned()->default(0);
            $table->tinyInteger('imei_field_type')->default(1)->unsigned();
            $table->string('image_name', 100)->nullable();
            $table->text('terms')->nullable();
            $table->boolean('allow_duplicate_imei')->default(0);
            $table->integer('api_id')->unsigned()->nullable();
            $table->integer('api_service_id')->unsigned()->nullable();
            $table->integer('sort_order')->unsigned()->default(0);
            $table->boolean('status')->default(1);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('category_id')
                ->references('id')->on('categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('network_id')
                ->references('id')->on('networks')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('api_id')
                ->references('id')->on('apis')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('services');
    }
}
