<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCreditCardTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_credit_card', function(Blueprint $table) {
            $table->increments('id');
            $table->string('first_name', 45);
            $table->string('last_name', 45);
            $table->string('card_number', 16);
            $table->string('brand', 20);
            $table->string('exp_month', 2);
            $table->string('exp_year', 4);
            $table->string('cvc', 3);
            $table->string('address_line_1', 255);
            $table->string('address_line_2', 255);
            $table->string('address_city', 100);
            $table->string('address_zip', 45);
            $table->string('address_country', 150);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('user_credit_card');
    }
}
