<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMnrServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mnr_services', function(Blueprint $table) {
            $table->increments('id');
            $table->string('name', 255);
            $table->decimal('amount', 10, 2);
            $table->string('amount_type', 15);
            $table->string('url')->nullable();
            $table->integer('category_id')->unsigned();
            $table->integer('sort_order')->unsigned()->default(0);
            $table->boolean('type')->default(1);
            $table->boolean('status')->default(1);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->foreign('category_id')
                ->references('id')->on('categories')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('mnr_services');
    }
}
