<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParcelInformationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('parcel_informations', function(Blueprint $table) {
            $table->increments('id');
            $table->string('parcel_contents', 100);
            $table->decimal('estimated_value', 10, 2);
            $table->text('bundle_data');
            $table->integer('collection_id')->unsigned();
            $table->boolean('collection_table_id');
            $table->integer('delivery_id')->unsigned();
//            $table->boolean('delivery_table_id');
//            $table->string('CollectionName', 100);
//            $table->string('CollectionCompany', 100)->nullable();
//            $table->string('CollectionAddress1');
//            $table->string('CollectionAddress2')->nullable();
//            $table->string('CollectionAddress3')->nullable();
//            $table->string('CollectionTown', 100);
//            $table->string('CollectionCounty', 100);
//            $table->string('CollectionPostcode', 20);
//            $table->string('CollectionTelephone', 20);
//            $table->string('CollectionCountry', 100);
//            $table->string('DeliveryName', 100);
//            $table->string('DeliveryCompany', 100)->nullable();
//            $table->string('DeliveryAddress1');
//            $table->string('DeliveryAddress2')->nullable();
//            $table->string('DeliveryAddress3')->nullable();
//            $table->string('DeliveryTown', 100);
//            $table->string('DeliveryCounty', 100);
//            $table->string('DeliveryPostcode', 20);
//            $table->string('DeliveryTelephone', 20);
//            $table->string('DeliveryCountry', 100);
//            $table->string('QuoteID', 100);
//            $table->string('ItemID', 100);
//            $table->date('CollectionDate');
//            $table->decimal('SubTotal', 10, 2);
//            $table->decimal('VatTotal', 10, 2);
//            $table->decimal('TotalPrice', 10, 2);
//            $table->string('OrderNumber', 100);
            $table->string('tracking_number', 45)->nullable();
            $table->boolean('status')->default(0);
            $table->integer('transaction_id')->unsigned();
            $table->boolean('type');
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
//            $table->foreign('collection_id')
//                ->references('id')->on('addresses')
//                ->onUpdate('cascade')
//                ->onDelete('cascade');
//            
            $table->foreign('delivery_id')
                ->references('id')->on('addresses')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('parcel_informations');
    }
}
