<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourierServiceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('courier_service', function(Blueprint $table) {
            $table->increments('id');
            $table->string('quote_id', 100);
            $table->string('item_id', 100);
            $table->date('collection_date');
            $table->decimal('sub_total', 10, 2);
            $table->decimal('vat_total', 10, 2);
            $table->decimal('total_price', 10, 2);
            $table->string('order_number', 100);
            $table->integer('parcel_information_id')->unsigned();
            
            $table->foreign('parcel_information_id')
                ->references('id')->on('parcel_informations')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('courier_service');
    }
}
