<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCargoServiceRatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cargo_service_rates', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('collection_country_id')->unsigned();
            $table->integer('delivery_country_id')->unsigned();
            $table->integer('cargo_service_id')->unsigned();
            $table->decimal('rate', 10, 2);
            $table->boolean('cargo_type');
            $table->boolean('status')->default(1);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->unique(array('collection_country_id', 'delivery_country_id', 'cargo_service_id'), 'unique_rate');
            
            $table->foreign('collection_country_id')
                ->references('id')->on('countries')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('delivery_country_id')
                ->references('id')->on('countries')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('cargo_service_id')
                ->references('id')->on('cargo_services')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('cargo_service_rates');
    }
}
