<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCargoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cargo', function(Blueprint $table) {
            $table->increments('id');
            $table->boolean('cargo_type');
            $table->integer('cargo_service_id')->unsigned();
            $table->integer('cargo_service_rate_id')->unsigned();
            $table->decimal('rate', 10, 2);
            $table->decimal('total', 10, 2);
            $table->integer('parcel_information_id')->unsigned();
            
            $table->foreign('cargo_service_id')
                ->references('id')->on('cargo_services')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('cargo_service_rate_id')
                ->references('id')->on('cargo_service_rates')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('parcel_information_id')
                ->references('id')->on('parcel_informations')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('cargo');
    }
}
