<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_invoices', function(Blueprint $table) {
            $table->increments('id');
            $table->decimal('sale_price', 10, 2);
            $table->decimal('cost_price', 10, 2);
            $table->integer('customer_id')->unsigned();
             $table->integer('table_id')->unsigned()->nullable();
            $table->integer('module_id')->unsigned();
            $table->text('description')->nullable();
            $table->integer('transaction_id')->unsigned();
            $table->integer('agent_transaction_id')->unsigned()->nullable();
            $table->boolean('status')->default(1);
            $table->integer('user_id')->unsigned();
            $table->timestamps();

            $table->foreign('customer_id')
                ->references('id')->on('customers')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('module_id')
                ->references('id')->on('modules')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('customer_invoices');
    }
}
