<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerInvoiceDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_invoice_data', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('invoice_id')->unsigned();
            $table->integer('custom_field_id')->unsigned();
            $table->text('field_value');
            $table->integer('user_id')->unsigned();
            $table->timestamps();

            $table->foreign('invoice_id')
                ->references('id')->on('customer_invoices')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('custom_field_id')
                ->references('id')->on('custom_fields')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('customer_invoice_data');
    }
}
