<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSimInformationDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sim_information_data', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('sim_information_id')->unsigned();
            $table->string('ssn');
            $table->string('cli')->nullable();
            $table->date('expired_date');
            $table->integer('sale_agent_id')->unsigned()->nullable();
            $table->dateTime('sale_agent_allotment_date')->nullable();
            $table->integer('agent_id')->unsigned()->nullable();
            $table->dateTime('agent_allotment_date')->nullable();
            $table->integer('user_id')->unsigned();
            $table->timestamps();

            $table->foreign('sim_information_id')
                ->references('id')->on('sim_informations')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('sale_agent_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('agent_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('sim_information_data');
    }
}
