<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNetworkIncentiveTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('network_incentive', function(Blueprint $table) {
            $table->increments('id');
            $table->dateTime('product_date');
            $table->string('product');
            $table->string('sim_number');
            $table->string('topup_level', 30);
            $table->string('topup_face_value', 10);
            $table->string('product_incentive', 10);
            $table->decimal('incentive', 10, 2)->default(0.00);
            $table->string('suspected_deduction', 10);
            $table->string('boundle_incentives', 10);
            $table->boolean('paid')->default(0);
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            
            $table->unique(array('sim_number', 'topup_level'), 'unique_incentive');
            
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('network_incentive');
    }
}
