<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        Eloquent::unguard();

        $this->call('PermissionSeeder');
        $this->call('GroupsSeeder');
        $this->call('UserSeeder');
        $this->call('CountriesTableSeeder');
        $this->call('CategoriesTableSeeder');
        $this->call('BanksTableSeeder');
        $this->call('BankAccountsTableSeeder');
        $this->call('BrandsTableSeeder');
        $this->call('AmountsTableSeeder');
        $this->call('ProductsTableSeeder');
        $this->call('AmountProductTableSeeder');
        $this->call('NetworksTableSeeder');
        $this->call('ServicesTableSeeder');
        $this->call('CustomFieldTypesTableSeeder');
        $this->call('ConfigsTableSeeder');
        $this->call('MnrServicesTableSeeder');
        $this->call('ModulesTableSeeder');
        $this->call('CustomFieldsTableSeeder');
        
        Eloquent::reguard();
    }
}

class PermissionSeeder extends Seeder
{
    public function run ()
    {
        $permission_repository = App::make('permission_repository');
        $permission1           = [
                "description" => "Superadmin",
                "permission"  => "_superadmin"
        ];
        $permission_repository->create($permission1);
        $permission2 = [
                "description" => "User Editor",
                "permission"  => "_user-editor"
        ];
        $permission_repository->create($permission2);
        $permission3 = [
                "description" => "Group Editor",
                "permission"  => "_group-editor"
        ];
        $permission_repository->create($permission3);
        $permission4 = [
                "description" => "Permission Editor",
                "permission"  => "_permission-editor"
        ];
        $permission_repository->create($permission4);
        $permission5 = [
                "description" => "Profile Type Editor",
                "permission"  => "_profile-editor"
        ];
        $permission_repository->create($permission5);
        
/*************************************User*************************************/
        
        $permission6 = [
                "description" => "Attractions",
                "permission"  => "_attractions"
        ];
        $permission_repository->create($permission6);
        $permission7 = [
                "description" => "Banking",
                "permission"  => "_banking"
        ];
        $permission_repository->create($permission7);
        $permission8 = [
                "description" => "Calling Cards",
                "permission"  => "_calling-cards"
        ];
        $permission_repository->create($permission8);
        $permission9 = [
                "description" => "Cargo Services",
                "permission"  => "_cargo-services"
        ];
        $permission_repository->create($permission9);
        $permission10 = [
                "description" => "Courier Services",
                "permission"  => "_courier-services"
        ];
        $permission_repository->create($permission10);
        $permission58 = [
                "description" => "Customer",
                "permission"  => "_customer"
        ];
        $permission_repository->create($permission58);
        $permission59 = [
                "description" => "Customer Invoice",
                "permission"  => "_customer-invoice"
        ];
        $permission_repository->create($permission59);
        $permission11 = [
                "description" => "Hotels",
                "permission"  => "_hotels"
        ];
        $permission_repository->create($permission11);
        $permission12 = [
                "description" => "Instant Credit",
                "permission"  => "_instant-credit"
        ];
        $permission_repository->create($permission12);
        $permission13 = [
                "description" => "International Topup",
                "permission"  => "_international-topup"
        ];
        $permission_repository->create($permission13);
        $permission14 = [
                "description" => "MNR Services",
                "permission"  => "_mnr-services"
        ];
        $permission_repository->create($permission14);
        $permission15 = [
                "description" => "MNR Marketing",
                "permission"  => "_mnr-marketing"
        ];
        $permission_repository->create($permission15);
        $permission16 = [
                "description" => "Mobiles",
                "permission"  => "_mobiles"
        ];
        $permission_repository->create($permission16);
        $permission60 = [
                "description" => "Settings",
                "permission"  => "_settings"
        ];
        $permission_repository->create($permission60);
        $permission17 = [
                "description" => "Sim",
                "permission"  => "_sim"
        ];
        $permission_repository->create($permission17);
        $permission18 = [
                "description" => "Ticket",
                "permission"  => "_ticket"
        ];
        $permission_repository->create($permission18);
        $permission19 = [
                "description" => "Top-up",
                "permission"  => "_top-up"
        ];
        $permission_repository->create($permission19);
        $permission20 = [
                "description" => "Tours",
                "permission"  => "_tours"
        ];
        $permission_repository->create($permission20);
        $permission21 = [
                "description" => "Unlocking Mobiles",
                "permission"  => "_unlocking-mobiles"
        ];
        $permission_repository->create($permission21);
//        $permission61 = [
//                "description" => "User Profile",
//                "permission"  => "_user-profile"
//        ];
//        $permission_repository->create($permission61);
        
/************************************Admin*************************************/
        
        $permission22 = [
                "description" => "Amount View",
                "permission"  => "_amount-view"
        ];
        $permission_repository->create($permission22);
        $permission23 = [
                "description" => "Amount Create",
                "permission"  => "_amount-create"
        ];
        $permission_repository->create($permission23);
        $permission24 = [
                "description" => "Amount Edit",
                "permission"  => "_amount-edit"
        ];
        $permission_repository->create($permission24);
        $permission85 = [
                "description" => "API View",
                "permission"  => "_api-view"
        ];
        $permission_repository->create($permission85);
        $permission86 = [
                "description" => "API Create",
                "permission"  => "_api-create"
        ];
        $permission_repository->create($permission86);
        $permission87 = [
                "description" => "API Edit",
                "permission"  => "_api-edit"
        ];
        $permission_repository->create($permission87);
        $permission25 = [
                "description" => "Bank View",
                "permission"  => "_bank-view"
        ];
        $permission_repository->create($permission25);
        $permission26 = [
                "description" => "Bank Create",
                "permission"  => "_bank-create"
        ];
        $permission_repository->create($permission26);
        $permission27 = [
                "description" => "Bank Edit",
                "permission"  => "_bank-edit"
        ];
        $permission_repository->create($permission27);
        $permission28 = [
                "description" => "Bank Account View",
                "permission"  => "_bank-account-view"
        ];
        $permission_repository->create($permission28);
        $permission29 = [
                "description" => "Bank Account Create",
                "permission"  => "_bank-account-create"
        ];
        $permission_repository->create($permission29);
        $permission30 = [
                "description" => "Bank Account Edit",
                "permission"  => "_bank-account-edit"
        ];
        $permission_repository->create($permission30);
        $permission31 = [
                "description" => "Brand View",
                "permission"  => "_brand-view"
        ];
        $permission_repository->create($permission31);
        $permission32 = [
                "description" => "Brand Create",
                "permission"  => "_brand-create"
        ];
        $permission_repository->create($permission32);
        $permission33 = [
                "description" => "Brand Edit",
                "permission"  => "_brand-edit"
        ];
        $permission_repository->create($permission33);
        $permission79 = [
                "description" => "Cargo Service View",
                "permission"  => "_cargo-service-view"
        ];
        $permission_repository->create($permission79);
        $permission80 = [
                "description" => "Cargo Service Create",
                "permission"  => "_cargo-service-create"
        ];
        $permission_repository->create($permission80);
        $permission81 = [
                "description" => "Cargo Service Edit",
                "permission"  => "_cargo-service-edit"
        ];
        $permission_repository->create($permission81);
        $permission82 = [
                "description" => "Cargo Service Rate View",
                "permission"  => "_cargo-service-rate-view"
        ];
        $permission_repository->create($permission82);
        $permission83 = [
                "description" => "Cargo Service Rate Create",
                "permission"  => "_cargo-service-rate-create"
        ];
        $permission_repository->create($permission83);
        $permission84 = [
                "description" => "Cargo Service Rate Edit",
                "permission"  => "_cargo-service-rate-edit"
        ];
        $permission_repository->create($permission84);
        $permission34 = [
                "description" => "Category View",
                "permission"  => "_category-view"
        ];
        $permission_repository->create($permission34);
        $permission35 = [
                "description" => "Category Create",
                "permission"  => "_category-create"
        ];
        $permission_repository->create($permission35);
        $permission36 = [
                "description" => "Category Edit",
                "permission"  => "_category-edit"
        ];
        $permission_repository->create($permission36);
        $permission37 = [
                "description" => "MNR Service View",
                "permission"  => "_mnr-service-view"
        ];
        $permission_repository->create($permission37);
        $permission38 = [
                "description" => "MNR Service Create",
                "permission"  => "_mnr-service-create"
        ];
        $permission_repository->create($permission38);
        $permission39 = [
                "description" => "MNR Service Edit",
                "permission"  => "_mnr-service-edit"
        ];
        $permission_repository->create($permission39);
        $permission40 = [
                "description" => "MNR Marketing View",
                "permission"  => "_mnr-marketing-view"
        ];
        $permission_repository->create($permission40);
        $permission41 = [
                "description" => "MNR Marketing Create",
                "permission"  => "_mnr-marketing-create"
        ];
        $permission_repository->create($permission41);
        $permission42 = [
                "description" => "MNR Marketing Edit",
                "permission"  => "_mnr-marketing-edit"
        ];
        $permission_repository->create($permission42);
        $permission43 = [
                "description" => "Mobile Product View",
                "permission"  => "_mobile-product-view"
        ];
        $permission_repository->create($permission43);
        $permission44 = [
                "description" => "Mobile Product Create",
                "permission"  => "_mobile-product-create"
        ];
        $permission_repository->create($permission44);
        $permission45 = [
                "description" => "Mobile Product Edit",
                "permission"  => "_mobile-product-edit"
        ];
        $permission_repository->create($permission45);
        $permission46 = [
                "description" => "Network View",
                "permission"  => "_network-view"
        ];
        $permission_repository->create($permission46);
        $permission47 = [
                "description" => "Network Create",
                "permission"  => "_network-create"
        ];
        $permission_repository->create($permission47);
        $permission48 = [
                "description" => "Network Edit",
                "permission"  => "_network-edit"
        ];
        $permission_repository->create($permission48);
        $permission62 = [
                "description" => "Network Commission View",
                "permission"  => "_network-commission-view"
        ];
        $permission_repository->create($permission62);
        $permission63 = [
                "description" => "Network Commission Create",
                "permission"  => "_network-commission-create"
        ];
        $permission_repository->create($permission63);
        $permission64 = [
                "description" => "Network Commission Edit",
                "permission"  => "_network-commission-edit"
        ];
        $permission_repository->create($permission64);
        $permission65 = [
                "description" => "Network Commission Scheme View",
                "permission"  => "_network-commission-scheme-view"
        ];
        $permission_repository->create($permission65);
        $permission66 = [
                "description" => "Network Commission Scheme Create",
                "permission"  => "_network-commission-scheme-create"
        ];
        $permission_repository->create($permission66);
        $permission67 = [
                "description" => "Network Commission Scheme Edit",
                "permission"  => "_network-commission-scheme-edit"
        ];
        $permission_repository->create($permission67);
        $permission68 = [
                "description" => "Network Incentive View",
                "permission"  => "_network-incentive-view"
        ];
        $permission_repository->create($permission68);
        $permission69 = [
                "description" => "Import Network Incentive",
                "permission"  => "_import-network-incentive"
        ];
        $permission_repository->create($permission69);
        $permission70 = [
                "description" => "Apply Network Incentive",
                "permission"  => "_apply-network-incentive"
        ];
        $permission_repository->create($permission70);
        $permission71 = [
                "description" => "Pay Network Incentive",
                "permission"  => "_pay-network-incentive"
        ];
        $permission_repository->create($permission71);
        $permission49 = [
                "description" => "Product View",
                "permission"  => "_product-view"
        ];
        $permission_repository->create($permission49);
        $permission50 = [
                "description" => "Product Create",
                "permission"  => "_product-create"
        ];
        $permission_repository->create($permission50);
        $permission51 = [
                "description" => "Product Edit",
                "permission"  => "_product-edit"
        ];
        $permission_repository->create($permission51);
        $permission52 = [
                "description" => "Pin Number View",
                "permission"  => "_pin-number-view"
        ];
        $permission_repository->create($permission52);
        $permission53 = [
                "description" => "Pin Number Create",
                "permission"  => "_pin-number-create"
        ];
        $permission_repository->create($permission53);
        $permission54 = [
                "description" => "Pin Number Edit",
                "permission"  => "_pin-number-edit"
        ];
        $permission_repository->create($permission54);
        $permission72 = [
                "description" => "Sale Agent SIM Allotment",
                "permission"  => "_sale-agent-sim-allotment"
        ];
        $permission_repository->create($permission72);
        $permission73 = [
                "description" => "Agent SIM Allotment",
                "permission"  => "_agent-sim-allotment"
        ];
        $permission_repository->create($permission73);
        $permission74 = [
                "description" => "SIM Information View",
                "permission"  => "_sim-information-view"
        ];
        $permission_repository->create($permission74);
        $permission75 = [
                "description" => "SIM Information Create",
                "permission"  => "_sim-information-create"
        ];
        $permission_repository->create($permission75);
        $permission76 = [
                "description" => "SIM Product View",
                "permission"  => "_sim-product-view"
        ];
        $permission_repository->create($permission76);
        $permission77 = [
                "description" => "SIM Product Create",
                "permission"  => "_sim-product-create"
        ];
        $permission_repository->create($permission77);
        $permission78 = [
                "description" => "SIM Product Edit",
                "permission"  => "_sim-product-edit"
        ];
        $permission_repository->create($permission78);
        $permission55 = [
                "description" => "Service View",
                "permission"  => "_service-view"
        ];
        $permission_repository->create($permission55);
        $permission56 = [
                "description" => "Service Create",
                "permission"  => "_service-create"
        ];
        $permission_repository->create($permission56);
        $permission57 = [
                "description" => "Service Edit",
                "permission"  => "_service-edit"
        ];
        $permission_repository->create($permission57);
    }
}

/**
 * @property mixed group_repository
 */
class GroupsSeeder extends Seeder
{

    public function run ()
    {
        $group_repository = App::make('group_repository');

        $group1 = [
                "name" => "superadmin",
                "permissions" => ["_superadmin" => 1]
        ];

        $group_repository->create($group1);
        
        $group2 = [
                "name" => "admin",
                "permissions" => ["_brand-view" => 1, "_category-view" => 1, "_mnr-service-view" => 1, "_mnr-marketing-view" => 1, "_mobile_product-view" => 1, "_network-view" => 1, "_product-view" => 1, "_pin-number-view" => 1, "_service-view" => 1]
        ];

        $group_repository->create($group2);
        
        $group3 = [
                "name" => "saleagent",
                "permissions" => ["_agent-sim-allotment" => 1]
        ];

        $group_repository->create($group3);
        
        $group4 = [
                "name" => "agent",
                "permissions" => ["_attractions" => 1, "_banking" => 1, "_calling-cards" => 1, "_cargo-services" => 1, "_courier-services" => 1, "_customer" => 1, "_customer-invoice" => 1, "_hotels" => 1, "_instant-credit" => 1, "_international-topup" => 1, "_mnr-services" => 1, "_mnr-marketing" => 1, "_mobiles" => 1, "_settings" => 1, "_sim" => 1, "_ticket" => 1, "_top-up" => 1, "_tours" => 1, "_unlocking-mobiles" => 1, "_user-editor" => 1]
        ];

        $group_repository->create($group4);
    }
}

class UserSeeder extends Seeder
{
    protected $admin_email = "admin@admin.com";
    protected $admin_password = "password";

    public function run ()
    {
        $user_repository = App::make('user_repository');
        $group_repository = App::make('group_repository');
        $profile_repository = App::make('profile_repository');

        $user_data = [
                "email" => $this->admin_email,
                "password" => $this->admin_password,
                "activated" => 1
        ];

        $user = $user_repository->create($user_data);

        $profile_repository->attachEmptyProfile($user);

        $superadmin_group = $this->getSuperadminGroup($group_repository);
        $user_repository->addGroup($user->id, $superadmin_group->id);
    }

    /**
     * @param $group_repository
     * @return mixed
     */
    private function getSuperadminGroup ($group_repository)
    {
        $superadmin_group = $group_repository->all(["name" => "superadmin"])->first();
        return $superadmin_group;
    }
}