var Login = function() {

    var handleLogin = function() {

        $('#login-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-red', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                email: {
                    required: true
                },
                password: {
                    required: true
                },
                remember: {
                    required: false
                },
                terms: {
                    required: true
                }
            },
            
            messages: {
                username: {
                    required: "Username is required."
                },
                password: {
                    required: "Password is required."
                },
                terms: {
                    required: "Accept Terms & Conditions."
                }
            },
            
            invalidHandler: function(event, validator) { //display error alert on form submit   
                toastr_call(2, '');
            },

            highlight: function(element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            success: function(label) {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },

            errorPlacement: function(error, element) {
                if(element.attr('name') == 'terms')
                {
                    error.insertAfter(element.closest('.mt-checkbox'));
                }else
                {
                    error.insertAfter(element);
                }
            },

            submitHandler: function(form) {
                form.submit(); // form validation success, call ajax form submit
            }
        });

        $('#forget-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                email: {
                    required: true
                }
            },

            invalidHandler: function(event, validator) { //display error alert on form submit   
                toastr_call(2, 'Enter email');
            },

            highlight: function(element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            success: function(label) {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },

            errorPlacement: function(error, element) {
                error.insertAfter(element.closest('.input-icon'));
            },

            submitHandler: function(form) {
                form.submit(); // form validation success, call ajax form submit
            }
        });
        
        $('#change-password').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                password: {
                    required: true,
                    minlength: 6
                }
            },

            invalidHandler: function(event, validator) { //display error alert on form submit   
                toastr_call(2, 'Enter password.');
            },

            highlight: function(element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            success: function(label) {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },

            errorPlacement: function(error, element) {
                error.insertAfter(element.closest('.input-icon'));
            },

            submitHandler: function(form) {
                form.submit(); // form validation success, call ajax form submit
            }
        });
        
        $('#login-form input').keypress(function(e) {
            if (e.which == 13) {
                if ($('#login-form').validate().form()) {
                    $('#login-form').submit(); //form validation success, call ajax form submit
                }
                return false;
            }
        });

        $('#forget-form input').keypress(function(e) {
            if (e.which == 13) {
                if ($('#forget-form').validate().form()) {
                    $('#forget-form').submit();
                }
                return false;
            }
        });

        $('#forget-password').click(function(){
            $('.login-form').hide();
            $('.forget-form').show();
        });

        $('#back-btn').click(function(){
            $('.login-form').show();
            $('.forget-form').hide();
        });
    }

    return {
        //main function to initiate the module
        init: function() {

            handleLogin();

            // init background slide images
            $('.login-bg').backstretch([
                base_url+"/packages/mnr_ehub/img/login_banner1.jpg"
                ], {
                  fade: 1000,
                  duration: 8000
                }
            );
        }
    };
}();

function toastr_call(message_type, message)
{
    var title;
    var shortCutFunction;
    
    if(message == '')
    {
        message = 'You have some form errors. Please check.';
    }
    
    if(message_type == 1)
    {
        shortCutFunction = 'success';
        title = 'Success!';
    }else if(message_type == 2)
    {
        shortCutFunction = 'error';
        title = 'Error!';
    }
    
    toastr.options = {
        closeButton: true,
        debug: false,
        positionClass: 'toast-bottom-right',
        onclick: null
    };

    toastr.options.showDuration = 1000;
    toastr.options.hideDuration = 1000;
    toastr.options.timeOut      = 10000;
    toastr.options.extendedTimeOut = 1000;
    toastr.options.showEasing = 'swing';
    toastr.options.hideEasing = 'linear';
    toastr.options.showMethod = 'slideDown';
    toastr.options.hideMethod = 'slideUp';

    var $toast = toastr[shortCutFunction](message, title); // Wire up an event handler to a button in the toast, if it exists
    $toastlast = $toast;
}

jQuery(document).ready(function() 
{
    Login.init();
});