var mnreHub = function () {
    
    var banking = function() {
        
	var return_url = base_url +'/transactions/transaction';
	var form       = $('#banking');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                date: {
                    required: true,
//                    date: true
                },
                bank_id: {
                    required: true
                },
                amount: {
                    required: true,
                    number: true
                },
                payment_ref: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    //Ahmed Mustafa ----Company Profile
    var companyProfile = function() {

        var return_url = base_url +'/user_profile?page='+$('input[name=page]').val();
        var form       = $('#company_profile');

        form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                image: {
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 200000 // Byte and it will be 200 KB
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) {
                if(element.attr('id') == 'image'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call_file_upload($(form), return_url);
            }
        });
    };
    
    var customField = function() {
        
        var return_url = base_url+"/settings";
        var form       = $('#custom_field');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',

            rules: {
                module_id: {
                    required: true
                },
                field_type_id: {
                    required: true
                },
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                }
            },
            
            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
        });
    };
    
    var courierAddress = function() {
        
	var form = $('#courier_address');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                first_name: {    
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                last_name: {    
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                company: {       
                    alphanumdashspace: true,
                    maxlength: 100
                },
                address1: {                    
                    required: true,
                    maxlength: 255
                },
                address2: { 
                    maxlength: 255
                },
                address3: {    
                    maxlength: 255
                },
                town: { 
                    required: true,
                    maxlength: 100
                },
                county: { 
                    required: true,
                    maxlength: 100
                },
                post_code: {
                    required: true
                },
                phone_no: {
                    required: true
                },
                country: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) {
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), '');
            }
	});
    };
    
    var courierServiceDetail = function() {
        
	var form = $('#courier_service_detail');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                country_id: {
                    required: true
                },
                cargo_service_id: {
                    required: true
                },
                parcel_contents: {                    
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                },
                estimated_value: {                    
                    required: true,
                    number: true
                },
                'item_name[]': {                    
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                },
                'weight[]': {  
                    required: true,
                    number: true
                },
                'dim1[]': {
                    required: true,
                    number: true
                },
                'dim2[]': {
                    required: true,
                    number: true
                },
                'dim3[]': {
                    required: true,
                    number: true
                },
                collection_id: {
                    required: true
                },
                collection_table_id: {
                    required: true
                },
                delivery_id: {
                    required: true
                }
/*              CollectionName: {    
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                },
                CollectionCompany: {       
                    alphanumdashspace: true,
                    maxlength: 100
                },
                CollectionAddress1: {                    
                    required: true,
                    maxlength: 255
                },
                CollectionAddress2: { 
                    maxlength: 255
                },
                CollectionAddress3: {    
                    maxlength: 255
                },
                CollectionTown: { 
                    required: true,
                    maxlength: 100
                },
                CollectionCounty: { 
                    required: true,
                    maxlength: 100
                },
                CollectionPostcode: {
                    required: true,
                    postcodeUK: true
                },
                CollectionTelephone: {
                    required: true,
                    mobileUK: true
                },
                CollectionCountry: {
                    required: true
                },
                DeliveryName: {    
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                },
                DeliveryCompany: {
                    alphanumdashspace: true,
                    maxlength: 100
                },
                DeliveryAddress1: {                    
                    required: true,
                    maxlength: 255
                },
                DeliveryAddress2: {                    
                    maxlength: 255
                },
                DeliveryAddress3: {                    
                    maxlength: 255
                },
                DeliveryTown: { 
                    required: true,
                    maxlength: 100
                },
                DeliveryCounty: { 
                    required: true,
                    maxlength: 100
                },
                DeliveryPostcode: {
                    required: true,
                    maxlength: 20
                },
                DeliveryTelephone: {
                    required: true,
                    digits: true,
                    minlength: 1,
                    maxlength: 20
                },
                DeliveryCountry: {
                    required: true
                }*/
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) {
                if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr('name') == 'collection_id')
                {
                    if(error.text() != '')
                    {
                        toastr_call(2, 'Collection Address not Selected..!');
                    }
                }else if(element.attr('name') == 'delivery_id')
                {
                    if(error.text() != '')
                    {
                        toastr_call(2, 'Delivery Address not Selected..!');
                    }
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                var type = $('input[name=type]').val();
                
                if(type == 1)
                {
                    lookup($(form));
                    return false;
                }else if(type == 2)
                {
                    var return_url = base_url +'/transactions/courier_service?type=2&cargo_type='+$('input[name=cargo_type]').val();
                    ajax_call($(form), return_url);
                }
            }
	});
    };
    
    var customer = function() {
        
	var form = $('#customer');
        var return_url = base_url +'/customers';
        
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                email: {
                    email: true
                },
                title: {
                    required: true,
                    lettersonly: true,
                    maxlength: 5
                },
                first_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                last_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                address_line_1: {
                    maxlength: 255
                },
                town: {
                    maxlength: 50
                },
                county: {
                    maxlength: 50
                },
                post_code: {
                    postcodeUK: true
                },
                phone_no: {
                    required: true,
                    minlength: 1,
                    maxlength: 20
                }                    
            },
            
            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url); 
            }
	});
    };
    
    var customerInvoice = function() {

        var form = $('#customer_invoice');

        form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                customer_name: {
                    required: true
                },
                module_id: {
                    required: true
                },
                cost_price: {
                    required: true,
                    number: true
                },
                sale_price: {
                    required: true,
                    number: true
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if(element.closest('.input-group').length > 0)
                {
                    error.insertAfter(element.closest('.input-group'));
                }else if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                
                var return_url;
                var module_id = $('input[name=module_id]').val();
                
                if(module_id == 1)
                {
                    return_url = base_url +'/transactions/attractions';
                }else if(module_id == 7)
                {
                    return_url = base_url +'/transactions/hotels';
                }else if(module_id == 13)
                {
                    return_url = base_url +'/transactions/ticket';
                }else if(module_id == 14)
                {
                    return_url = base_url +'/transactions/tours';
                }else
                {
                    return_url = base_url +'/customers/customer_invoice';
                }
                
                ajax_call($(form), return_url);
            }
        });
    };
    
    var quoteToInvoice = function() {

        var form = $('#quote_to_invoice');
        var return_url = base_url +'/transactions/ticket';
        
        form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                customer_name: {
                    required: true
                },
                created_date: {
                    required: true
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                
                ajax_call($(form), return_url);
            }
        });
    };
    
    var instantCredit = function() {
        
	var form = $('#instant_credit');
 
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                amount: {
                    required: true,
                    number: true,
                    min: 100
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                var payment_method = $('input[name=payment_method]').val();
                var amount = $('input[name=amount]').val();
                var deduct = (amount * 5) / 100;
                var updatedAmount = amount - deduct;
            
                if(payment_method == 'paypal')
                {
                    var message =   '<h4><b>Please confirm the information below is correct before completing this recharge</b></h4>'+ 
                                '<table class="table table-bordered margin-top-30">'+
                                    '<tr><th>Amount</td><td>'+amount+'</td>'+
                                    '<tr><th>Charges</td><td>5%</td>'+
                                    '<tr><th>Total</td><td>'+updatedAmount+'</td>'+
                                '</table>';
                    bootbox.confirm(message, function(result) 
                    {
                        if(result == true)
                        {
                           form.submit();
                           return false;
                        }
                    }); 
                }else
                {
                    lookup($(form));
                    return false;
                }
            }
	});
    };
    
    var instantCreditStripe = function() {
        
	var form = $('#instant_credit_stripe');
        var return_url = base_url +'/transactions/instant_credit_stripe_receipt';
        
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                card: {
                    required: true
                },
                first_name: {
                    maxlength: 45
                },
                last_name: {
                    maxlength: 45
                },
                card_number: {
                    minlength: 16,
                    maxlength: 16
                },
                cvc: {
                    minlength: 3,
                    maxlength: 3
                },
                address_line_1: {
                    maxlength: 255
                },
                address_line_2: {
                    maxlength: 255
                },
                address_city: {
                    maxlength: 100
                },
                address_zip: {
                    postcodeUK: true,
                    maxlength: 45
                }                
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                
                var payment_method;
                var amount = $('input[name=amount]').val();
                var card   = $('input[name="card"]:checked').val();
            
                if(card == 0)
                {
                    var card_number = $('input[name=card_number]').val();
                    payment_method = $('#brand :selected').text()+' xxxxxxxxxxxx'+card_number.substr(card_number.length - 4);
                }else
                {
                    payment_method = $('input[name=card_number_'+card+']').val();
                }
                
                var message =   '<h4><b>Please confirm the information below is correct before completing this recharge</b></h4>'+ 
                                '<table class="table table-bordered margin-top-30">'+
                                    '<tr><th>Amount</td><td>'+amount+'</td>'+
                                    '<tr><th>Payment Method</td><td>'+payment_method+'</td>'+
                                '</table>';
                bootbox.confirm(message, function(result) 
                {
                    if(result == true)
                    {
                       ajax_call($(form), return_url);
                    }
                });
                return false; 
            }
	});
    };
    
    var mobilOrder = function() {
        
	var return_url = base_url +'/transactions/mobile_order';
	var form       = $('#mobile_order');
   
	form.validate({
            
            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    //Ahmed Mustafa ----Modules
    var module = function() {

        var return_url = base_url +'/settings';
        var form       = $('#module');

        form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 100
                }
            },

            invalidHandler: function (event, validator) {
                toastr_call(2, '');
            },

            highlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error');
            },

            unhighlight: function (element) {
                $(element)
                    .closest('.form-group').removeClass('has-error');
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            },

            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
        });
    };
    
    var mnrService = function() {
        
	var return_url = base_url +'/transactions/mnr_service_detail?service_id='+$('input[name=service_id]').val();
	var form       = $('#mnr_service');
	
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',
            rules: {
                first_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                last_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                email : {
                    required: true,
                    email: true
                },
                phone_no : {
                    required: true,
                    phoneUK: true
                },
                mobile_no : {
                    required: true,
                    mobileUK: true
                }
            },
            
            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },
            
            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var simOrder = function() {
        
	var return_url = base_url +'/transactions/sim_order';
	var form       = $('#sim_order');
   
	form.validate({
            
            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var topup = function() {
        
	var form = $('#topup');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                category_id: {
                    required: true
                },
                product_id: {
                    required: true
                },
                amount: {
                    required: true,
                    number: true
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr('id') == 'amount'){
//                    $('#price_error').show();
//                    $('#price_error span').html('Price is not selected..!');
                    if(error.text() != '')
                    {
                        toastr_call(2, 'Price is not selected..!');
                    }
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
//                if($(element).attr('id') == 'amount'){
//                    $('#price_error').hide();
//                }
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                var return_url;
                if($('input[name=category_id]').val() == 1)
                {
                    return_url = base_url +'/transactions/topup?category=1';
                }else
                {
                    return_url = base_url +'/transactions/topup?category=0';
                }
                ajax_call($(form), return_url);
            }
	});
    };
    
    var unlockingMobile = function() {
        
	var return_url = base_url +'/transactions/unlocking_mobile_detail?service_id='+$('input[name=service_id]').val();
	var form       = $('#unlocking_mobile');
   
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',
            rules: {
                'imei_number[]': {
                    required: true,
                    digits: true,
                    minlength: 15,
                    maxlength: 15,
                    duplicateimeis: true
                }
            },
            
            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },
            
            submitHandler: function (form) {
                ajax_call($(form), return_url);
            }
	});
    };
    
    var updateAvatar = function() {
        
	var form = $('#update_avatar');

        form.validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: '',  // validate all fields including form hidden input
            rules: {
                avatar: {
                    required: true,
                    extension: 'jpg,jpeg,png,gif',
                    filesize: 400000 // Byte and it will be 400 KB
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            errorPlacement: function (error, element) { 
                if(element.attr('name') == 'avatar'){
                    error.insertAfter('.fileinput');
                }else{
                    error.insertAfter(element);
                }
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_file_upload_acl($(form));
            }
	});
    };
    
    var updatePassword = function() {
        
	var form = $('#update_password');
	  
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                password: {
                    required: true,
                    minlength: 6
                },
                password_confirmation: {
                    required: true,
                    minlength: 6,
                    equalTo: '#password'
                }
            },

            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },

            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                ajax_call_acl2($(form));
            }
	});
    };
    
    var userProfile = function() {
        
	var form = $('#user_profile');
        var return_url = base_url +'/user_profile?page='+$('input[name=page]').val();
        
	form.validate({
            errorElement: 'span', 
            errorClass: 'help-block help-block-error', 
            focusInvalid: false, 
            ignore: '',  
            rules: {
                title: {
                    required: true,
                    lettersonly: true,
                    maxlength: 5
                },
                first_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                last_name: {
                    required: true,
                    alphanumdashspace: true,
                    maxlength: 50
                },
                mobile_no : {
                    required: true,
                    mobileUK: true
                },
                business_no : {
                    phoneUK: true
                },   
                company: {
                    required: true,
                    maxlength: 50
                },
                vat: {
                    maxlength: 20
                },
                town: {
                    maxlength: 50
                },
                county: {
                    maxlength: 50
                },
                zip: {
                    postcodeUK: true
                },
                address: {
                    required: true
                }                    
            },
            
            invalidHandler: function (event, validator) {               
                toastr_call(2, '');
            },
            
            errorPlacement: function (error, element) { 
                if (element.hasClass('select2')) {
                    error.insertAfter(element.next('.select2-container'));
                }else{
                    error.insertAfter(element);
                }
            },
            
            highlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-success').addClass('has-error'); 
            },

            unhighlight: function (element) { 
                $(element)
                    .closest('.form-group').removeClass('has-error'); 
            },

            success: function (label, element) {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); 
            },

            submitHandler: function (form) {
                
                ajax_call($(form), return_url); 
            }
	});
    };
    
    var table = function() {
        
        var table = $('.datatable2');

        table.dataTable({

            // Internationalisation. For more info refer to http://datatables.net/manual/i18n
            'language': {
                'aria': {
                    'sortAscending': ': activate to sort column ascending',
                    'sortDescending': ': activate to sort column descending'
                },
                'emptyTable': 'No data available in table',
                'info': 'Showing _START_ to _END_ of _TOTAL_ records',
                'infoEmpty': 'No records found',
                'infoFiltered': '(filtered1 from _MAX_ total records)',
                'lengthMenu': 'Show _MENU_',
                'search': 'Search:',
                'zeroRecords': 'No matching records found',
                'paginate': {
                    'previous':'Prev',
                    'next': 'Next',
                    'last': 'Last',
                    'first': 'First'
                }
            },

            // Uncomment below line('dom' parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
            // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js). 
            // So when dropdowns used the scrollable div should be removed. 
            //'dom': '<'row'<'col-md-6 col-sm-12'l><'col-md-6 col-sm-12'f>r>t<'row'<'col-md-5 col-sm-12'i><'col-md-7 col-sm-12'p>>',

            'bStateSave': true, // save datatable state(pagination, sort, etc) in cookie.
            'pagingType': 'bootstrap_extended',
/*
            'lengthMenu': [
                [5, 15, 20, -1],
                [5, 15, 20, 'All'] // change per page values here
            ],*/
            // set the initial value
            'pageLength': 25,
            'columnDefs': [{  // set default column settings
                'orderable': false,
                'targets': [-1]
            }, {
                'searchable': false,
                'targets': [-1]
            }]
        });
    };
    
    var scripts = function() {
         
//-----------------------------------Select2------------------------------------
        
        $.fn.select2.defaults.set('theme', 'bootstrap');

        $('.select2, .select2-multiple').select2({
            width: null,
            minimumResultsForSearch: 7
        }).on('change', function() {
            $(this).valid();
        });
        
//-------------------------------WYSIHTML5 Editor-------------------------------
/*
        if (!jQuery().wysihtml5) {
            return;
        }

        if ($('.wysihtml5').size() > 0) {
            $('.wysihtml5').wysihtml5({
                "stylesheets": ["packages/metronic/global/plugins/bootstrap-wysihtml5/wysiwyg-color.css"]
            });
        }
*/
//------------------------------Summernote Editor-------------------------------

        $('.summernote').summernote({height: 300});
        
//---------------------------------Date Picker----------------------------------

        $('.date-picker').datepicker({
            format: 'dd/mm/yyyy',                
            rtl: App.isRTL(),
            orientation: "left",
            autoclose: true
        }).on('changeDate', function() {
            $(this).valid();
        });

//----------------------------------Touchspin-----------------------------------
        
        $(".digits").TouchSpin({
            min: 0,
            max: 1000000,
            step: 1,
            boostat: 5,
            maxboostedstep: 10
        });
        
        $(".touchspin").TouchSpin({
            min: 0,
            max: 1000000,
            step: 0.01,
            decimals: 2,
            boostat: 5,
            maxboostedstep: 10,
            prefix: '£'
        });

//----------------------------------CountDown-----------------------------------
/*
        var austDay = new Date();
        austDay = new Date(austDay.getFullYear() + 1, 1 - 1, 26);
        $('#defaultCountdown').countdown({until: austDay});
        $('#year').text(austDay.getFullYear());
*/            
//------------------------------Validation Methods------------------------------
        
        $.validator.addMethod('alphanumdashspace', function(value, element) {
//                return this.optional(element) || /^[\a-zA-Z][\a-zA-Z0-9-_\s]+$/i.test(value);
                return this.optional(element) || /^[\a-zA-Z0-9-_\s]+$/i.test(value);
        }, 'Letters, numbers, dashes and space only please');
        
        $.validator.addMethod('duplicateimeis', function(value, element) 
        {
            var error = 0;
            var id = $(element).attr('id');

            $('.imeis').each(function() 
            {
                var imei_id = $(this).attr('id');
                
                if(value != '' && value == $('#'+imei_id).val() && id != imei_id)
                {
                    error = 1;
                }                
            });
                
            if(error == 1)
            {
                return false;
            }else
            {
                return true;
            }
        }, 'Duplicate IMEI Not allowed!');
        
        $.validator.addMethod('filesize', function (value, element, param) {
            return this.optional(element) || (element.files[0].size <= param)
        }, 'File size must be less than {0}');
    };
    
    return {
 
        init: function () {    
            banking();            
            courierAddress();
            courierServiceDetail();
            customField();
            customer();
            customerInvoice();
            quoteToInvoice();
            companyProfile();
            instantCredit();
            instantCreditStripe();
            mobilOrder();
            module();
            mnrService();
            simOrder();
            topup();
            unlockingMobile();
            updateAvatar();
            updatePassword();
            userProfile();
            table();
            scripts();
        }
    };
}();

function lookup(val)
{
    App.scrollTop();
    var pageContentBody = $('.page-content-row');
    App.startPageLoading();

    $.ajax({
        url  : val.attr('action'),
        type : val.attr('method'),
        data : val.serialize(),
        success: function(res){
            App.stopPageLoading();
            pageContentBody.html(res);
            App.initAjax(); // initialize core stuff
        },
        statusCode: {
            500:function() {
                pageContentBody.html(error_500);
            },
            401:function() { 
                pageContentBody.html(error_401); 
            },
            404:function() { 
                pageContentBody.html(error_404);
            }
        },
        error: function (data, ajaxOptions, thrownError) {
            App.stopPageLoading();
                
            var status = data.status;
            if(status == 422)
            {
                var response = '';
                var errors = $.parseJSON(data.responseText);

                $.each(errors, function(index, value) {
                    response += value + '<br>'; 
                });
                
                toastr_call(2, response);
            }else
            {
                pageContentBody.html(error_500);
            }
        }
    });
}

function lookup2(html_class, url, data)
{
    App.scrollTop();
    var pageContentBody = $('.'+html_class);
    App.startPageLoading();

    $.ajax({
        url  : url,
        type : 'GET',
        data : data,
        success: function(res){
            App.stopPageLoading();
            pageContentBody.html(res);
            App.initAjax(); // initialize core stuff
        },
        statusCode: {
            500:function() {
                pageContentBody.html(error_500);
            },
            401:function() { 
                pageContentBody.html(error_401); 
            },
            404:function() { 
                pageContentBody.html(error_404);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            App.stopPageLoading();
            pageContentBody.html(error_500);
        }
    });
}

function ajax_call(form, return_url)  
{
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        dataType: 'json',
        success: function(data)
        {
            if(data.response == 'success')
            {
                if(data.module == 'courier_address')
                {
                    if(data.table == 1)
                    {
                        $.get('transactions/courier_user_profile', function(data) 
                        {
                            $("#user_profile").html(data);
                        });
                    }else
                    {
                        if(data.customer_id != '')
                        {
                            $('#customer_id').val(data.customer_id);
                        }
                    
                        if(data.customer_name != '')
                        {
                            $('#customer_name').val(data.customer_name);
                            $('#delivery_customer_name').val(data.customer_name);
                        }
                    
                        if(data.address_type == 1)
                        {
                            $.ajaxSetup({async:false});
                            
                            $.get('transactions/filter_courier_addresses?address_type=1&country_id='+data.country_id+'&customer_id='+data.customer_id, function(data) 
                            {
                                $('#collection_addresses').html(data);
                            });
                            
                            $('#collection_toggle').removeClass("courier_expand").addClass("courier_collapse");
                            $('#collection').slideDown(200);
                            $('input[name=collection_id][value='+data.id+']').prop('checked', true);
                        }
                    
                        if(data.address_type == 2)
                        {
                            var id;

                            if(data.customer_id != '')
                            {
                                id = '&customer_id='+data.customer_id;
                            }else
                            {
                                id = '&id='+data.id;
                            }
                            
                            $.ajaxSetup({async:false});
                            
                            $.get('transactions/filter_courier_addresses?address_type=2&country_id='+data.country_id+id, function(data) 
                            {
                                $('#delivery_addresses').html(data);
                            });
                            
                            $('#delivery_toggle').removeClass("courier_expand").addClass("courier_collapse");
                            $('#delivery').slideDown(200);
                            $('input[name=delivery_id][value='+data.id+']').prop('checked', true);
                        }
                    }
                    
                    $('#address_modal').modal('hide');
                }else if(data.module == 'customer_modal')
                {
                    $('#customer_id').val(data.customer_id);
                    $('#customer_name').val(data.customer_name);
                    $('#add_customer').modal('hide');
                    toastr_call(1, 'Customer added!');
                }else
                {
                    if(data.module_id == 5 || data.module_id == 6)
                    {
                        return_url = base_url +'/customers/customer_invoice?customer_id='+data.customer_id+'&customer_name='+data.customer_name+'&module_id='+data.module_id+'&id='+data.id;
                    }
                    
                    return_page(return_url);
                }
                get_balance();                
            }else
            {
                toastr_call(2, data.message);
            }
            
            $('.modal-backdrop').fadeOut();
            btn.button('reset');
        },
        error : function(data) 
        { 
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else if(status == 422)
            {
                var response = '';
                var errors = $.parseJSON(data.responseText);

                $.each(errors, function(index, value) {
                    response += value + '<br>'; 
                });
                
                toastr_call(2, response);
            }else
            {
                toastr_call(2, error_500_2);
            }
            
            $('.modal-backdrop').fadeOut();
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call2(data, url)
{   
    App.blockUI({
        target: '#portlet',
        iconOnly: true
    });
    
    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        dataType: 'html',
        success: function(data)
        {
            $('#html').html(data);
            $('.select2').select2();
            App.unblockUI('#portlet');
        },
        error : function(data) 
        {  
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else
            {
                toastr_call(2, error_500_2);
            }
            App.unblockUI('#portlet');
        }
    });
}

function ajax_call3(data, url, return_url)
{
    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        dataType: 'json',
        success: function(data)
        {
            if(data.response == 'success')
            {
                return_page(return_url);
                get_balance();
            }else
            {
                toastr_call(2, data.message);
            }
        },
        error : function(data) 
        {  
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else
            {
                toastr_call(2, error_500_2);
            }
        }
    });
}

function ajax_call_file_upload(form, return_url)
{
    var formData = new FormData(form[0]);

    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');

    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: formData,
        dataType: 'json',
        async: false,
        cache: false,
        contentType: false,
        processData: false,
        success: function(data)
        {
            if(data.response == 'success')
            {
                return_page(return_url);
            }else
            {
                toastr_call(2, data.message);
            }
            btn.button('reset');
        },
        error : function(data)
        {
            var status = data.status;
            if(status == 401)
            {
                toastr_call(2, error_401_2);
            }else if(status == 404)
            {
                toastr_call(2, error_404_2);
            }else if(status == 422)
            {
                var response = '';
                var errors = $.parseJSON(data.responseText);

                $.each(errors, function(index, value) {
                    response += value + '<br>';
                });

                toastr_call(2, response);
            }else
            {
                toastr_call(2, error_500_2);
            }

            btn.button('reset');
        }
    });
    return false;
}

function ajax_call_acl(form)  
{
    App.scrollTop();
    var pageContentBody = $('.page-content-row');
    App.startPageLoading();
    
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        dataType: 'html',
        success: function(data)
        {
            App.stopPageLoading();
            pageContentBody.html(data);
            App.initAjax(); // initialize core stuff
        },
        error : function() 
        { 
            toastr_call(2, error_500_2);
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call_acl2(form)  
{
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        dataType: 'html',
        async: false,
        success: function()
        {
            form.find('input[type=password]').val('');
            toastr_call(1, 'Password is updated successfully');
            btn.button('reset');
        },
        error : function() 
        { 
            toastr_call(2, error_500_2);
            btn.button('reset');
        }
    });
    return false;
}

function ajax_call_file_upload_acl(form)  
{
    var formData = new FormData(form[0]);
    
    var btn = form.find($('input[type=submit]'));
    btn.attr('data-loading-text', 'Loading...');
    btn.button('loading');
    
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: formData,
        dataType: 'html',
        async: false,
        cache: false,
        contentType: false,
        processData: false,
        success: function()
        {
            window.location.href = base_url;
        },
        error : function() 
        { 
            toastr_call(2, error_500_2);
            btn.button('reset');
        }
    });
    return false;
}

function return_page(url)
{
    App.scrollTop();
    var pageContentBody = $('.page-content-row');
    App.startPageLoading();

    $.ajax({
        type: 'GET',
        cache: false,
        url: url,
        dataType: 'html',
        success: function (res) {
            App.stopPageLoading();
            pageContentBody.html(res);
            App.initAjax(); // initialize core stuff
        },
        statusCode: {
            500:function() {
                pageContentBody.html(error_500);
            },
            401:function() { 
                pageContentBody.html(error_401); 
            },
            404:function() { 
                pageContentBody.html(error_404);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            App.stopPageLoading();
            pageContentBody.html(error_500);
        }
    });
}       

function get_balance()
{
    $.get(base_url+'/transactions/get_balance', function(data) 
    {
        $('#balance').html(data);
    });
}

function toastr_call(message_type, message)
{
    var title;
    var shortCutFunction;
    
    if(message == '')
    {
        message = 'You have some form errors. Please check.';
    }
    
    if(message_type == 1)
    {
        shortCutFunction = 'success';
        title = 'Success!';
    }else if(message_type == 2)
    {
        shortCutFunction = 'error';
        title = 'Error!';
    }
    
    toastr.options = {
        closeButton: true,
        debug: false,
        positionClass: 'toast-bottom-right',
        onclick: null
    };

    toastr.options.showDuration = 1000;
    toastr.options.hideDuration = 1000;
    toastr.options.timeOut      = 10000;
    toastr.options.extendedTimeOut = 1000;
    toastr.options.showEasing = 'swing';
    toastr.options.hideEasing = 'linear';
    toastr.options.showMethod = 'slideDown';
    toastr.options.hideMethod = 'slideUp';

    var $toast = toastr[shortCutFunction](message, title); // Wire up an event handler to a button in the toast, if it exists
    $toastlast = $toast;
}

var interval;

function start_interval(time)
{
    interval =  setInterval(
            function()
            {
                var url = base_url+'/reports/unlocking_mobile_status?page=3';
                $.get(url, function(data) 
                {
                    $('#result').html(data);
                });                
                return false;
            }, time);
    return false;
}

function stop_interval()
{
    clearInterval(interval); 
    return false;
}