<div class="col-md-12 col-sm-12">    
    <div class="row widget-row">
        <div class="col-md-3">
            <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                <h4 class="widget-thumb-heading">Pending Users</h4>
                <div class="widget-thumb-wrap">
                    <i class="widget-thumb-icon bg-green icon-bulb"></i>
                    <div class="widget-thumb-body">
<!--                        <span class="widget-thumb-subtitle">USD</span>-->
                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="7,644">{{ $userCount }}</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                <h4 class="widget-thumb-heading">Pending Banking</h4>
                <div class="widget-thumb-wrap">
                    <i class="widget-thumb-icon bg-red icon-layers"></i>
                    <div class="widget-thumb-body">
<!--                        <span class="widget-thumb-subtitle">USD</span>-->
                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="1,293">{{ $bankingCount }}</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                <h4 class="widget-thumb-heading">Pending SIM Orders</h4>
                <div class="widget-thumb-wrap">
                    <i class="widget-thumb-icon bg-purple icon-screen-desktop"></i>
                    <div class="widget-thumb-body">
<!--                        <span class="widget-thumb-subtitle">USD</span>-->
                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{ $simOrderCount->count() }}</span>
                    </div>
                </div>
            </div> 
        </div>
        <div class="col-md-3">
            <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                <h4 class="widget-thumb-heading">Mobile Orders</h4>
                <div class="widget-thumb-wrap">
                    <i class="widget-thumb-icon bg-blue icon-bar-chart"></i>
                    <div class="widget-thumb-body">
<!--                        <span class="widget-thumb-subtitle">USD</span>-->
                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="5,071">{{ $mobileOrderCount->count() }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>    
    <div class="portlet light bordered">
        <div class="portlet-title tabbable-line">
            <div class="caption">
                <i class=" icon-social-twitter font-dark hide"></i>
                <span class="caption-subject font-dark bold uppercase">Quick Actions</span>
            </div>
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab_01" data-toggle="tab"> Banking </a>
                </li>
                <li>
                    <a href="#tab_02" data-toggle="tab"> SIM Orders </a>
                </li>
                <li>
                    <a href="#tab_03" data-toggle="tab"> Mobile Orders </a>
                </li>
                <li>
                    <a href="#tab_04" data-toggle="tab"> Unlocking Mobiles </a>
                </li>
                <li>
                    <a href="#tab_05" data-toggle="tab"> Professional Services Marketing </a>
                </li>
            </ul>
        </div>
        <div class="portlet-body">
            <div class="tab-content">
                <div class="tab-pane active" id="tab_01">
                    <div class="mt-actions">
                        @if($banking->count() > 0)
                            @foreach($banking as $row)
                                <div class="mt-action">
                                    <div class="mt-action-img"> 
                                        <img src="{{ $row->userProfile->presenter()->avatar(41) }}" width="41">
                                    </div>
                                    <div class="mt-action-body">
                                        <div class="mt-action-row">
                                            <div class="mt-action-info ">
                                                <div class="mt-action-icon ">
                                                    <i class="icon-magnet"></i>
                                                </div>
                                                <div class="mt-action-details ">
                                                    <span class="mt-action-author">
                                                        <a href="{{ URL::route('users.edit', ['id' => $row->user_id]) }}" class="ajaxify">
                                                            {{ getUserName($row) }}
                                                        </a>
                                                    </span>
                                                    <p class="mt-action-desc">
                                                        Payment Ref: {{ $row->payment_ref }}<br>
                                                        Bank: {{ $row->bank->name }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="font-green-sharp">{{ getGlobalValue('currency') }}{{ $row->amount }}</span>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="mt-action-date">{{ date('d M Y', strtotime($row->date)) }}</span>
                                            </div>
                                            <div class="mt-action-buttons ">
                                                <div class="btn-group btn-group-circle">
                                                    <button type="button" id="{{ $row->id }}" status="1" class="btn btn-outline green btn-sm approved">Approve</button>
                                                    <button type="button" id="{{ $row->id }}" status="2" class="btn btn-outline red btn-sm reject">Reject</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            No Record Found
                        @endif
                        <a href="{{ url('/reports/banking_list') }}" class="btn btn-circle red btn-outline pull-right margin-top-20 ajaxify">Banking List</a>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div class="tab-pane" id="tab_02">
                    <div class="mt-actions">
                        @if($simOrder->count() > 0)
                            @foreach($simOrder as $row)
                                <div class="mt-action">
                                    <div class="mt-action-img"> 
                                        <img src="{{ $row->userProfile->presenter()->avatar(41) }}" width="41">
                                    </div>
                                    <div class="mt-action-body">
                                        <div class="mt-action-row">
                                            <div class="mt-action-info ">
                                                <div class="mt-action-icon ">
                                                    <i class="icon-magnet"></i>
                                                </div>
                                                <div class="mt-action-details ">
                                                    <span class="mt-action-author">
                                                        <a href="{{ URL::route('users.edit', ['id' => $row->user_id]) }}" class="ajaxify">
                                                            {{ getUserName($row) }}
                                                        </a>
                                                    </span>
                                                    <p class="mt-action-desc">
                                                        Order No: 
                                                        <a href="{{ url('admin/'.$row->transaction_id.'/sim_order_detail') }}" data-toggle="modal" data-target="#sim_order_detail">
                                                            {{ $row->transaction_id }}
                                                        </a>
                                                        <br>
                                                        Quantity: {{ $row->quantity }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="mt-action-date">{{ date('d M Y', strtotime($row->created_at)) }}</span>
                                            </div>
                                            <div class="mt-action-buttons ">
                                                <div class="btn-group btn-group-circle">
                                                    <button type="button" id="{{ $row->transaction_id }}" status="1" class="btn btn-outline green btn-sm sim_delivered">Deliver</button>
                                                    <button type="button" id="{{ $row->transaction_id }}" status="2" class="btn btn-outline red btn-sm sim_cancel">Cancel</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            No Record Found
                        @endif
                        <a href="{{ url('/admin/sim_order_list') }}" class="btn btn-circle red btn-outline pull-right margin-top-20 ajaxify">SIM Orders List</a>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div class="tab-pane" id="tab_03">
                    <div class="mt-actions">
                        @if($mobileOrder->count() > 0)
                            @foreach($mobileOrder as $row)
                                <div class="mt-action">
                                    <div class="mt-action-img"> 
                                        <img src="{{ $row->userProfile->presenter()->avatar(41) }}" width="41">
                                    </div>
                                    <div class="mt-action-body">
                                        <div class="mt-action-row">
                                            <div class="mt-action-info ">
                                                <div class="mt-action-icon ">
                                                    <i class="icon-magnet"></i>
                                                </div>
                                                <div class="mt-action-details ">
                                                    <span class="mt-action-author">
                                                        <a href="{{ URL::route('users.edit', ['id' => $row->user_id]) }}" class="ajaxify">
                                                            {{ getUserName($row) }}
                                                        </a>
                                                    </span>
                                                    <p class="mt-action-desc">
                                                        Order No: 
                                                        <a href="{{ url('admin/'.$row->transaction_id.'/mobile_order_detail') }}" data-toggle="modal" data-target="#mobile_order_detail">
                                                            {{ $row->transaction_id }}
                                                        </a>
                                                        <br>
                                                        Quantity: {{ $row->quantity }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="font-green-sharp">{{ getGlobalValue('currency') }}{{ $row->total }}</span>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="mt-action-date">{{ date('d M Y', strtotime($row->created_at)) }}</span>
                                            </div>
                                            <div class="mt-action-buttons ">
                                                <div class="btn-group btn-group-circle">
                                                    <button type="button" id="{{ $row->transaction_id }}" status="1" class="btn btn-outline green btn-sm mobile_delivered">Deliver</button>
                                                    <button type="button" id="{{ $row->transaction_id }}" status="2" class="btn btn-outline red btn-sm mobile_cancel">Cancel</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            No Record Found
                        @endif
                        <a href="{{ url('/admin/mobile_order_list') }}" class="btn btn-circle red btn-outline pull-right margin-top-20 ajaxify">Mobile Orders List</a>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div class="tab-pane" id="tab_04">
                    <div class="mt-actions">
                        @if($unlockingMobile->count() > 0)
                            @foreach($unlockingMobile as $row)
                                <div class="mt-action">
                                    <div class="mt-action-img"> 
                                        <img src="{{ $row->userProfile->presenter()->avatar(41) }}" width="41">
                                    </div>
                                    <div class="mt-action-body">
                                        <div class="mt-action-row">
                                            <div class="mt-action-info ">
                                                <div class="mt-action-icon ">
                                                    <i class="icon-magnet"></i>
                                                </div>
                                                <div class="mt-action-details ">
                                                    <span class="mt-action-author">
                                                        <a href="{{ URL::route('users.edit', ['id' => $row->user_id]) }}" class="ajaxify">
                                                            {{ getUserName($row) }}
                                                        </a>
                                                    </span>
                                                    <p class="mt-action-desc">
                                                        Order Number: 
                                                        <a href="{{ url('admin/'.$row->id.'/unlocking_mobile_detail') }}" data-toggle="modal" data-target="#unlocking_mobile_detail">
                                                            {{ $row->transaction_id }}
                                                        </a>    
                                                        <br>
                                                        Service: {{ $row->service->name }}<br>
                                                        IMEI: {{ $row->imei_number }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="font-green-sharp">{{ getGlobalValue('currency') }}{{ $row->price }}</span>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="mt-action-date">{{ date('d M Y', strtotime($row->created_at)) }}</span>
                                            </div>
                                            <div class="mt-action-buttons ">
                                                <div class="btn-group btn-group-circle">
                                                    <button type="button" id="{{ $row->id }}" status="1" cost_price="{{ $row->service->cost_price }}" class="btn btn-outline green btn-sm complete">Complete</button>
                                                    <button type="button" id="{{ $row->id }}" status="2" cost_price="{{ $row->service->cost_price }}" class="btn btn-outline red btn-sm unlocking_mobile_reject">Reject</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            No Record Found
                        @endif
                        <a href="{{ URL::route('unlocking_mobile_list', ['page' => 1]) }}" class="btn btn-circle red btn-outline pull-right margin-top-20 ajaxify">Unlocking Mobile List</a>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div class="tab-pane" id="tab_05">
                    <div class="mt-actions">
                        @if($professionalService->count() > 0)
                            @foreach($professionalService as $row)
                                <div class="mt-action">
                                    <div class="mt-action-img"> 
                                        <img src="{{ $row->userProfile->presenter()->avatar(41) }}" width="41">
                                    </div>
                                    <div class="mt-action-body">
                                        <div class="mt-action-row">
                                            <div class="mt-action-info ">
                                                <div class="mt-action-icon ">
                                                    <i class="icon-magnet"></i>
                                                </div>
                                                <div class="mt-action-details ">
                                                    <span class="mt-action-author">
                                                        <a href="{{ URL::route('users.edit', ['id' => $row->user_id]) }}" class="ajaxify">
                                                            {{ getUserName($row) }}
                                                        </a>
                                                    </span>
                                                    <p class="mt-action-desc">
                                                        Referral Name: {{ $row->first_name }} {{ $row->last_name }}<br>
                                                        Referral Email: {{ $row->email }}<br>
                                                        Service: {{ $row->service->name }}<br>
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="font-green-sharp">{{ $row->service->amount }} {{ ($row->service->amount_type == 'fixed')?getGlobalValue('currency'):'%' }}</span>
                                            </div>
                                            <div class="mt-action-datetime ">
                                                <span class="mt-action-date">{{ date('d M Y', strtotime($row->created_at)) }}</span>
                                            </div>
                                            <div class="mt-action-buttons ">
                                                <div class="btn-group btn-group-circle">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            No Record Found
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="mobile_order_detail" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<div class="modal fade" id="sim_order_detail" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<div class="modal fade" id="unlocking_mobile_detail" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
@include('admin.unlocking_mobile_modal')
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//---------------------------Banking Approved/Reject----------------------------

        $('.approved, .reject').click(function()
        {
            var message;
            var id = $(this).attr('id');
            var status = $(this).attr('status');
            if(status == 1)
            {
                message = 'Are you sure you want to approved this record?';            
            }else if(status == 2)
            {
                message = 'Are you sure you want to reject this record?';            
            }
            
            var data = 'id='+id+'&approved='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/admin/banking_approved';
            var return_url = base_url+'/admin/dashboard';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
//---------------------------Mobile Delivered/Cancel----------------------------

        $('.mobile_delivered, .mobile_cancel').click(function()
        {
            var id = $(this).attr('id');
            var status = $(this).attr('status');
            var message = 'Are you sure you want to update status?';
            
            var data = 'transaction_id='+id+'&delivered='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/admin/mobile_delivered';
            var return_url = base_url+'/admin/dashboard';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
//-----------------------------SIM Delivered/Cancel-----------------------------

        $('.sim_delivered, .sim_cancel').click(function()
        {
            var id = $(this).attr('id');
            var status = $(this).attr('status');
            var message = 'Are you sure you want to update status?';
            
            var data = 'transaction_id='+id+'&delivered='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/admin/sim_delivered';
            var return_url = base_url+'/admin/dashboard';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
//-----------------------Unlocking Mobile Complete/Reject-----------------------

        $('.complete, .unlocking_mobile_reject').click(function()
        {
            var id = $(this).attr('id');
            var status = $(this).attr('status');
            var cost_price = $(this).attr('cost_price');
            
            if(status == 2)
            {
                $('#refund').show();
            }else
            {
                $('#refund').hide();
            }
            $('input[name="id"]').val(id);
            $('input[name="status"]').val(status);
            $('input[name="cost_price"]').val(cost_price);
            $('#unlocking_mobile_modal').modal('show');
        });
/*        
        $('#update_status').click(function()
        {
            var form = $('#update_description');
            var error = $('.alert-danger', form);
            var response = form.find('textarea[name="response"]').val();
            
            var message = 'Are you sure you want to update status?';            
            
            var data = 'id='+id+'&status='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/admin/unlocking_mobile_status_update';
            var return_url = base_url+'/admin/dashboard';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });*/
    });
</script>    