<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Edit Config
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::model($config, [
                    'method' => 'PATCH',
                    'url' => ['/configs', $config->id],
                    'id' => 'config', 'class' => 'form-horizontal'
                ]) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Config Key<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('config_key', null, ['class' => 'form-control', 'readonly' => '']) }}
                                        {{ Form::hidden('type', null) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Config Value<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        @if($config->type == 'boolean')
                                            {{ Form::select('config_value', ['no' => 'No', 'yes' => 'Yes'], null, ['class' => 'form-control select2']) }}
                                        @elseif($config->type == 'digits')
                                            {{ Form::text('config_value', null, ['class' => 'form-control digits']) }}
                                        @elseif($config->type == 'decimal')
                                            {{ Form::text('config_value', null, ['class' => 'form-control touchspin']) }}
                                        @elseif($config->type == 'select')
                                            <?php $possibleValues = explode(',', $config->possible_values);
                                                foreach($possibleValues as $value):
                                                    $configValue[$value] = $value;
                                                endforeach; ?>
                                            {{ Form::select('config_value', $configValue , null, ['class' => 'form-control select2']) }}
                                        @elseif($config->type == 'textarea')
                                            {{ Form::textarea('config_value', null, ['class' => 'form-control summernote', 'size' => '30x8']) }}
                                        @elseif($config->type == 'email')
                                            {{ Form::text('config_value', null, ['class' => 'form-control', 'email' => 'true']) }}
                                        @else
                                            {{ Form::text('config_value', null, ['class' => 'form-control']) }}
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Possible Values
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('possible_values', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Description
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::textarea('description', null, ['class' => 'form-control', 'size' => '30x3']) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/configs';
            return_page(url);
            return false;
        });
    });
</script>