<div class="modal fade" id="invoice" tabindex="-1" role="basic" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            {{ Form::open(['url' => '/customers/customer_invoice', 'id' => 'customer_invoice', 'class' => 'form-horizontal']) }}
                {{ Form::hidden('customer_id', null, ['id' => 'customer_id']) }}
                {{ Form::hidden('module_id', $moduleId) }}
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title">
                        <?php $submit = ($moduleId == 13)?'Generate Quote':'Generate Invoice';?>
                        @if($moduleId == 13)
                            Generate Quote
                        @else
                            Generate Customer Invoice
                        @endif
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="form-group margin-top-20">
                        <label class="col-md-2 control-label">Customer <span class="required" aria-required="true">*</span></label>
                        <div class="col-md-4">
                            {{ Form::text('customer_name', null, ['id' => 'customer_name', 'readonly' => '', 'class' => 'form-control']) }}
                        </div>
                        <div class="col-md-4">
                            <a href="#basic" data-toggle="modal" class="btn red customer_lookup">Lookup</a>
                            <a href="#add_customer" data-toggle="modal" class="btn red">Add Customer</a>
                        </div>
                    </div>
                    <div id="custom_data"></div>
                    <div class="form-group">
                        <label class="control-label col-md-2">
                            MNR Price<span class="required"> * </span>
                        </label>
                        <div class="col-md-5">
                            {{ Form::text('cost_price', $costPrice, ['class' => 'form-control', 'readonly' => '']) }}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-2">
                            Sale Price<span class="required"> * </span>
                        </label>
                        <div class="col-md-5">
                            {{ Form::text('sale_price', null, ['class' => 'form-control touchspin']) }}
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-2">
                            Description
                        </label>
                        <div class="col-md-10">
                            {{ Form::textarea('description', null, ['class' => 'form-control summernote']) }}
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
                    {{ Form::submit($submit, ['class' => 'btn grey-mint']) }}
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
@include('customers.customer_lookup')
@include('customers.create_customer_modal')
<div class="modal fade" id="receipt" data-backdrop="static" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>                                            
<script type="text/javascript">
    jQuery(document).ready(function()
    {
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif

//----------------------------Get Custom Fields Data----------------------------

        get_custom_data('{{ $moduleId }}');
        
        function get_custom_data(module_id)
        {
            if(module_id != '')
            {
                App.blockUI({
                    target: '#invoice',
                    iconOnly: true
                });
                $.get('customers/get_custom_data?module_id='+module_id+'&modal=1', function(data) 
                {
                    $('#custom_data').html(data);
                });
                App.unblockUI('#invoice');
            }else
            {
                $('#custom_data').html('');
            }
        }
        
//-----------------------------Get Customer Receipt-----------------------------

        <?php if (Session::has('customer_invoice_id')):?>
            $('#receipt').modal('show');

            $.get(base_url+"/customers/customer_receipt?customer_invoice_id={{ Session::get('customer_invoice_id') }}", function(data) 
            {
                $('#receipt .modal-content').html(data);
            });
        <?php endif;?>    
    });
</script>