<div class="modal fade bs-modal-lg" id="basic" tabindex="-1" role="basic" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Customer Lookup</h4>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-bordered table-hover customer_datatable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>First Name</th>
                            <th>Last Name</th>
                            <th>Email</th>
                            <th>Post Code</th>
                            <th>Phone No.</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function()
    {
//------------------------------Get Customer Data-------------------------------

        var table = $('.customer_datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/customers/get_customer_data?type=2',
            'order': [
                [1, "asc"]
            ],
            'columns': [
                { data: 'id' },
                { data: 'first_name' },
                { data: 'last_name' },
                { data: 'email' },
                { data: 'address.post_code', name: 'address.post_code' },
                { data: 'address.phone_no', name: 'address.phone_no' }
            ]
        });

//-------------------------------Customer Details-------------------------------

        $('.customer_datatable').on('click', '.customer_details', function ()
        {
            var val   = $(this).attr('id');
            var value = val.split('|');
            $("#customer_id").val(value[0]);
            $("#customer_name").val(value[1]);
            $("#basic").modal('hide');
        });
    });
</script>