<div class="modal fade" id="quote" tabindex="-1" role="basic" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            {{ Form::open(['url' => '/customers/quote_to_invoice', 'id' => 'quote_to_invoice', 'class' => 'form-horizontal']) }}
                {{ Form::hidden('customer_id', null, ['id' => 'quote_customer_id']) }}
                {{ Form::hidden('quote_id', null, ['id' => 'quote_id']) }}
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title">
                        Generate Customer Invoice
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="form-group margin-top-20">
                        <label class="col-md-2 control-label">Customer <span class="required" aria-required="true">*</span></label>
                        <div class="col-md-4">
                            {{ Form::text('customer_name', null, ['id' => 'quote_customer_name', 'readonly' => '', 'class' => 'form-control']) }}
                        </div>
                        <div class="col-md-4">
                            <a href="#basic" data-toggle="modal" class="btn red customer_lookup">Lookup</a>
                            <a href="#add_customer" data-toggle="modal" class="btn red">Add Customer</a>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-2 control-label">Quote ID <span class="required" aria-required="true">*</span></label>
                        <div class="col-md-4">
                            {{ Form::text('created_date', null, ['id' => 'created_date', 'readonly' => '', 'class' => 'form-control']) }}
                        </div>
                        <div class="col-md-4">
                            <a href="{{ url('customers/get_quotes') }}" id="get_quotes" data-toggle="modal" data-target="#quote_lookup" class="btn red display-hide">Quote Lookup</a>
                        </div>
                    </div>
                    <div id="quote_custom_data"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
                    {{ Form::submit('Generate Invoice', ['class' => 'btn grey-mint']) }}
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
<div class="modal fade" id="quote_lookup" role="basic" aria-hidden="true">
    <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function()
    {
//----------------------------Get Custom Fields Data----------------------------

        get_custom_data('{{ $moduleId }}');
        
        function get_custom_data(module_id)
        {
            if(module_id != '')
            {
                App.blockUI({
                    target: '#quote',
                    iconOnly: true
                });
                $.get('customers/get_custom_data?module_id='+module_id+'&modal=2', function(data) 
                {
                    $('#quote_custom_data').html(data);
                });
                App.unblockUI('#quote');
            }else
            {
                $('#quote_custom_data').html('');
            }
        }
        
//----------------------------------Get Quotes----------------------------------

        $('.customer_datatable').on('click', '.customer_details', function ()
        {
            var val   = $(this).attr('id');
            var value = val.split('|');
        
            $("#quote_customer_id").val(value[0]);
            $("#quote_customer_name").val(value[1]);
            $('#get_quotes').attr('href', 'customers/get_quotes?customer_id='+value[0]);
            $('#get_quotes').show();
        });        
    });
</script>