<!DOCTYPE html>
<html lang="en-US">
    <head>
        <style>
            table {
                width: 100%; 
                font-family: Arial;
                font-size: 12pt;
                color: #000; 
                line-height: 1.5;
                margin: auto; 
                border-collapse: collapse;   
            }
            td {
                text-align: left;
            }
            .address{
                font-weight: 500; 
            }
            .title{
                font-weight: bold;
            }       
        </style>
    </head>
    <body>
        <table border="0" cellpadding="10" cellspacing="0" align="center" width="100%">
            <?php $companyProfile = getCompanyProfile(); ?>
            <tr>
                <td><img src="{{ asset($companyProfile["company_logo"]) }}" style="width:175px;"></td>
            </tr>
            <tr>
                <td class="address"><span style="font-weight:bold">Address:</span><br /> {!! $companyProfile["header"] !!}</td>
            </tr>
            <tr>
                <td colspan="4"><h3>Dear {{ $body['user_name'] }},</h3></td>
            </tr>
            <tr>
                <td colspan="4">
                    e-Banking Details Transaction Id: {{ $body['transaction_id'] }}
                    <hr></td>
            </tr>
            <tr>
                <td class="title" width="30%">Transaction Id:</td>
                <td width="70%">{{ $body['transaction_id'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Date:</td>
                <td width="70%">{{ $body['date'] }}</td>
            </tr>
            <tr>
                <td colspan="4"><hr></td>
            </tr>
            <tr>
                <td class="title" width="30%">Bank Name:</td>
                <td width="70%">{{ $body['bank'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Payment Ref:</td>
                <td width="70%">{{ $body['payment_ref'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Amount</td>
                <td width="70%">{{ getGlobalValue('currency') }}{{ $body['amount'] }}</td>
            </tr>
            <tr>
                <td colspan="4">Regards <br/>{{ Config::get('acl_base.app_name') }} Team</td>
            </tr>
        </table>
    </body>    
</html>